/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.centrality.ClosenessCentralityProc;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.impl.closeness.MSClosenessCentrality;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.closeness.stream", description="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.", executionMode=ExecutionMode.STREAM)
public class ClosenessCentralityStreamProc
extends ClosenessCentralityProc<MSClosenessCentrality.Result> {
    @Procedure(name="gds.alpha.closeness.stream", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<MSClosenessCentrality.Result> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig, Stream<MSClosenessCentrality.Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
            Graph graph = computationResult.graph();
            if (graph.isEmpty()) {
                graph.release();
                return Stream.empty();
            }
            graph.release();
            return algorithm.resultStream();
        };
    }
}

