/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.centrality;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.NodePropertiesWriter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.gds.impl.closeness.MSClosenessCentrality;

public abstract class ClosenessCentralityProc<PROC_RESULT>
extends NodePropertiesWriter<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig, PROC_RESULT> {
    protected static final String DESCRIPTION = "Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    protected ClosenessCentralityConfig newConfig(String username, CypherMapWrapper config) {
        return ClosenessCentralityConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig>(){

            public String taskName() {
                return "ClosenessCentrality";
            }

            public MSClosenessCentrality build(Graph graph, ClosenessCentralityConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new MSClosenessCentrality(graph, configuration.concurrency(), configuration.improved(), allocationTracker, Pools.DEFAULT, progressTracker);
            }
        };
    }
}

