/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.approxmaxkcut;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.approxmaxkcut.ApproxMaxKCutProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.approxmaxkcut.ApproxMaxKCut;
import org.neo4j.gds.impl.approxmaxkcut.config.ApproxMaxKCutMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.maxkcut.mutate", description="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY)
public class ApproxMaxKCutMutateProc
extends MutatePropertyProc<ApproxMaxKCut, ApproxMaxKCut.CutResult, MutateResult, ApproxMaxKCutMutateConfig> {
    @Procedure(value="gds.alpha.maxkcut.mutate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.alpha.maxkcut.mutate.estimate", mode=Mode.READ)
    @Description(value="Approximate Maximum k-cut maps each node into one of k disjoint communities trying to maximize the sum of weights of relationships between these communities.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ApproxMaxKCutMutateConfig newConfig(String username, CypherMapWrapper config) {
        return ApproxMaxKCutMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<ApproxMaxKCut, ApproxMaxKCutMutateConfig> algorithmFactory() {
        return ApproxMaxKCutProc.algorithmFactory();
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, ApproxMaxKCutMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder(((ApproxMaxKCut.CutResult)computeResult.result()).cutCost());
    }

    protected NodeProperties nodeProperties(ComputationResult<ApproxMaxKCut, ApproxMaxKCut.CutResult, ApproxMaxKCutMutateConfig> computationResult) {
        return ApproxMaxKCutProc.nodeProperties(computationResult);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;
        public final double cutCost;

        MutateResult(long nodePropertiesWritten, double cutCost, long preProcessingMillis, long computeMillis, long postProcessingMillis, long mutateMillis, Map<String, Object> config) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, mutateMillis, config);
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.cutCost = cutCost;
        }

        static final class Builder
        extends AbstractResultBuilder<MutateResult> {
            private final double cutCost;

            Builder(double cutCost) {
                this.cutCost = cutCost;
            }

            public MutateResult build() {
                return new MutateResult(this.nodePropertiesWritten, this.cutCost, this.preProcessingMillis, this.computeMillis, 0L, this.mutateMillis, this.config.toMap());
            }
        }
    }
}

