/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.ann;

import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.similarity.ApproxNearestNeighborsAlgorithm;
import org.neo4j.gds.impl.similarity.ApproximateNearestNeighborsConfig;
import org.neo4j.gds.impl.similarity.ApproximateNearestNeighborsConfigImpl;
import org.neo4j.gds.impl.similarity.CosineAlgorithm;
import org.neo4j.gds.impl.similarity.CosineConfig;
import org.neo4j.gds.impl.similarity.EuclideanAlgorithm;
import org.neo4j.gds.impl.similarity.EuclideanConfig;
import org.neo4j.gds.impl.similarity.ImmutableCosineConfig;
import org.neo4j.gds.impl.similarity.ImmutableEuclideanConfig;
import org.neo4j.gds.impl.similarity.ImmutableJaccardConfig;
import org.neo4j.gds.impl.similarity.ImmutablePearsonConfig;
import org.neo4j.gds.impl.similarity.JaccardAlgorithm;
import org.neo4j.gds.impl.similarity.JaccardConfig;
import org.neo4j.gds.impl.similarity.PearsonAlgorithm;
import org.neo4j.gds.impl.similarity.PearsonConfig;
import org.neo4j.gds.impl.similarity.SimilarityAlgorithm;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.impl.similarity.SimilarityInput;
import org.neo4j.gds.similarity.AlphaSimilarityProc;

public abstract class ApproxNearestNeighborsProc<PROC_RESULT>
extends AlphaSimilarityProc<ApproxNearestNeighborsAlgorithm<SimilarityInput>, ApproximateNearestNeighborsConfig, PROC_RESULT> {
    protected static final String DESCRIPTION = "The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.";

    protected ApproximateNearestNeighborsConfig newConfig(String username, CypherMapWrapper config) {
        return new ApproximateNearestNeighborsConfigImpl(config);
    }

    @Override
    protected ApproxNearestNeighborsAlgorithm<SimilarityInput> newAlgo(ApproximateNearestNeighborsConfig config, AllocationTracker allocationTracker) {
        SimilarityAlgorithm<?, SimilarityInput> similarity = this.similarityAlgorithm(config);
        return new ApproxNearestNeighborsAlgorithm(config, similarity, this.api, this.log, Pools.DEFAULT, ProgressTracker.NULL_TRACKER, allocationTracker);
    }

    @Override
    protected String taskName() {
        return "ApproximateNearestNeighbors";
    }

    SimilarityAlgorithm<?, ? extends SimilarityInput> similarityAlgorithm(ApproximateNearestNeighborsConfig config) {
        switch (config.algorithm()) {
            case jaccard: {
                JaccardConfig jaccardConfig = ImmutableJaccardConfig.builder().from((SimilarityConfig)config).build();
                return new JaccardAlgorithm((SimilarityConfig)jaccardConfig, this.api);
            }
            case cosine: {
                CosineConfig cosineConfig = ImmutableCosineConfig.builder().from((SimilarityConfig)config).build();
                return new CosineAlgorithm(cosineConfig, this.api);
            }
            case pearson: {
                PearsonConfig pearsonConfig = ImmutablePearsonConfig.builder().from((SimilarityConfig)config).build();
                return new PearsonAlgorithm((SimilarityConfig)pearsonConfig, this.api);
            }
            case euclidean: {
                EuclideanConfig euclideanConfig = ImmutableEuclideanConfig.builder().from((SimilarityConfig)config).build();
                return new EuclideanAlgorithm(euclideanConfig, this.api);
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + config.algorithm() + " (sad java \ud83d\ude1e)");
    }
}

