/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpath;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.ShortestPathDeltaStepping;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.DeltaSteppingProcResult;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.shortestPath.deltaStepping.write", description="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class ShortestPathDeltaSteppingWriteProc
extends ShortestPathDeltaSteppingProc<DeltaSteppingProcResult> {
    @Procedure(value="gds.alpha.shortestPath.deltaStepping.write", mode=Mode.WRITE)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<DeltaSteppingProcResult> deltaStepping(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<ShortestPathDeltaStepping, ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig, Stream<DeltaSteppingProcResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            ShortestPathDeltaStepping algorithm = (ShortestPathDeltaStepping)computationResult.algorithm();
            ShortestPathDeltaSteppingConfig config = (ShortestPathDeltaSteppingConfig)computationResult.config();
            AbstractResultBuilder builder = DeltaSteppingProcResult.builder().withNodeCount(graph.nodeCount());
            if (graph.isEmpty()) {
                return Stream.empty();
            }
            try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
                final double[] shortestPaths = algorithm.getShortestPaths();
                DoubleNodeProperties properties = new DoubleNodeProperties(){

                    public long size() {
                        return computationResult.graph().nodeCount();
                    }

                    public double doubleValue(long nodeId) {
                        return shortestPaths[(int)nodeId];
                    }
                };
                TaskProgressTracker progressTracker = new TaskProgressTracker(NodePropertyExporter.baseTask((String)"ShortestPathDeltaStepping", (long)graph.nodeCount()), this.log, config.writeConcurrency(), this.taskRegistryFactory);
                this.nodePropertyExporterBuilder.withIdMap((IdMap)graph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).parallel(Pools.DEFAULT, config.writeConcurrency()).build().write(config.writeProperty(), (NodeProperties)properties);
            }
            return Stream.of((DeltaSteppingProcResult)builder.build());
        };
    }
}

