/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpath;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.impl.ShortestPathDeltaStepping;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.shortestPath.deltaStepping.stream", description="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.", executionMode=ExecutionMode.STREAM)
public class ShortestPathDeltaSteppingStreamProc
extends ShortestPathDeltaSteppingProc<ShortestPathDeltaStepping.DeltaSteppingResult> {
    @Procedure(name="gds.alpha.shortestPath.deltaStepping.stream", mode=Mode.READ)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<ShortestPathDeltaStepping.DeltaSteppingResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<ShortestPathDeltaStepping, ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig, Stream<ShortestPathDeltaStepping.DeltaSteppingResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            if (computationResult.graph().isEmpty()) {
                return Stream.empty();
            }
            return ((ShortestPathDeltaStepping)computationResult.result()).resultStream();
        };
    }
}

