/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.pregel.SpeakerListenerLPA;
import org.neo4j.gds.pregel.SpeakerListenerLPAAlgorithm;
import org.neo4j.gds.pregel.proc.PregelMutateProc;
import org.neo4j.gds.pregel.proc.PregelMutateResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.sllpa.mutate", executionMode=ExecutionMode.MUTATE_NODE_PROPERTY, description="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
public final class SpeakerListenerLPAMutateProc
extends PregelMutateProc<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> {
    @Procedure(name="gds.alpha.sllpa.mutate", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelMutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.sllpa.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected AbstractResultBuilder<PregelMutateResult> resultBuilder(ComputationResult<SpeakerListenerLPAAlgorithm, PregelResult, SpeakerListenerLPA.SpeakerListenerLPAConfig> computeResult, ExecutionContext executionContext) {
        int ranIterations = ((PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((PregelResult)computeResult.result()).didConverge();
        return new PregelMutateResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected SpeakerListenerLPA.SpeakerListenerLPAConfig newConfig(String username, CypherMapWrapper config) {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.of(config);
    }

    public GraphAlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> algorithmFactory() {
        return new GraphAlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig>(){

            public SpeakerListenerLPAAlgorithm build(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new SpeakerListenerLPAAlgorithm(graph, configuration, allocationTracker, progressTracker);
            }

            public String taskName() {
                return SpeakerListenerLPAAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                SpeakerListenerLPA computation = new SpeakerListenerLPA();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isPresent(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

