/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.WriteProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.nodemodels.NodeClassificationCompanion;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictWriteConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.ml.nodeClassification.predict.write", description="Predicts classes for all nodes based on a previously trained model", executionMode=ExecutionMode.WRITE_NODE_PROPERTY)
public class NodeClassificationPredictWriteProc
extends WriteProc<NodeClassificationPredict, NodeClassificationResult, Result, NodeClassificationPredictWriteConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.write", mode=Mode.WRITE)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<Result> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult result = this.compute(graphName, configuration);
        return this.write(result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.write.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected List<NodeProperty> nodePropertyList(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationPredictWriteConfig> computationResult) {
        NodeClassificationPredictWriteConfig config = (NodeClassificationPredictWriteConfig)computationResult.config();
        String writeProperty = config.writeProperty();
        NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)writeProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)((String)config.predictedProbabilityProperty().orElseThrow()), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    public ValidationConfiguration<NodeClassificationPredictWriteConfig> validationConfig() {
        return NodeClassificationCompanion.getValidationConfig(this.modelCatalog);
    }

    protected NodeClassificationPredictWriteConfig newConfig(String username, CypherMapWrapper config) {
        return NodeClassificationPredictWriteConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<NodeClassificationPredict, NodeClassificationPredictWriteConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory(this.modelCatalog);
    }

    protected AbstractResultBuilder<Result> resultBuilder(ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationPredictWriteConfig> computeResult, ExecutionContext executionContext) {
        return new Result.Builder();
    }

    public static class Result {
        public final long writeMillis;
        public final long nodePropertiesWritten;
        public final long preProcessingMillis;
        public final long computeMillis;
        public final Map<String, Object> configuration;

        public Result(long preProcessingMillis, long computeMillis, long writeMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            this.preProcessingMillis = preProcessingMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodePropertiesWritten = nodePropertiesWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<Result> {
            Builder() {
            }

            public Result build() {
                return new Result(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

