/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrain;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainResult;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionTrainResult", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionTrainResult
implements LinkPredictionTrainResult {
    private final Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model;
    private final LinkPredictionTrain.ModelSelectResult modelSelectionStatistics;

    private ImmutableLinkPredictionTrainResult(Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, LinkPredictionTrain.ModelSelectResult modelSelectionStatistics) {
        this.model = Objects.requireNonNull(model, "model");
        this.modelSelectionStatistics = Objects.requireNonNull(modelSelectionStatistics, "modelSelectionStatistics");
    }

    private ImmutableLinkPredictionTrainResult(ImmutableLinkPredictionTrainResult original, Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, LinkPredictionTrain.ModelSelectResult modelSelectionStatistics) {
        this.model = model;
        this.modelSelectionStatistics = modelSelectionStatistics;
    }

    @Override
    public Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model() {
        return this.model;
    }

    @Override
    public LinkPredictionTrain.ModelSelectResult modelSelectionStatistics() {
        return this.modelSelectionStatistics;
    }

    public final ImmutableLinkPredictionTrainResult withModel(Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> value) {
        if (this.model == value) {
            return this;
        }
        Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> newValue = Objects.requireNonNull(value, "model");
        return new ImmutableLinkPredictionTrainResult(this, newValue, this.modelSelectionStatistics);
    }

    public final ImmutableLinkPredictionTrainResult withModelSelectionStatistics(LinkPredictionTrain.ModelSelectResult value) {
        if (this.modelSelectionStatistics == value) {
            return this;
        }
        LinkPredictionTrain.ModelSelectResult newValue = Objects.requireNonNull(value, "modelSelectionStatistics");
        return new ImmutableLinkPredictionTrainResult(this, this.model, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionTrainResult && this.equalTo((ImmutableLinkPredictionTrainResult)another);
    }

    private boolean equalTo(ImmutableLinkPredictionTrainResult another) {
        return this.model.equals(another.model) && this.modelSelectionStatistics.equals(another.modelSelectionStatistics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.model.hashCode();
        h += (h << 5) + this.modelSelectionStatistics.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionTrainResult{model=" + this.model + ", modelSelectionStatistics=" + this.modelSelectionStatistics + "}";
    }

    public static LinkPredictionTrainResult of(Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model, LinkPredictionTrain.ModelSelectResult modelSelectionStatistics) {
        return new ImmutableLinkPredictionTrainResult(model, modelSelectionStatistics);
    }

    public static LinkPredictionTrainResult copyOf(LinkPredictionTrainResult instance) {
        if (instance instanceof ImmutableLinkPredictionTrainResult) {
            return (ImmutableLinkPredictionTrainResult)instance;
        }
        return ImmutableLinkPredictionTrainResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LinkPredictionTrainResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL = 1L;
        private static final long INIT_BIT_MODEL_SELECTION_STATISTICS = 2L;
        private long initBits = 3L;
        @Nullable
        private Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model;
        @Nullable
        private LinkPredictionTrain.ModelSelectResult modelSelectionStatistics;

        private Builder() {
        }

        public final Builder from(LinkPredictionTrainResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.model(instance.model());
            this.modelSelectionStatistics(instance.modelSelectionStatistics());
            return this;
        }

        public final Builder model(Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model) {
            this.model = Objects.requireNonNull(model, "model");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modelSelectionStatistics(LinkPredictionTrain.ModelSelectResult modelSelectionStatistics) {
            this.modelSelectionStatistics = Objects.requireNonNull(modelSelectionStatistics, "modelSelectionStatistics");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.model = null;
            this.modelSelectionStatistics = null;
            return this;
        }

        public LinkPredictionTrainResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLinkPredictionTrainResult(null, this.model, this.modelSelectionStatistics);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("model");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modelSelectionStatistics");
            }
            return "Cannot build LinkPredictionTrainResult, some of required attributes are not set " + attributes;
        }
    }
}

