/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.ml.linkmodels.pipeline.train.FeaturesAndTargets;

@ParametersAreNonnullByDefault
@Generated(from="FeaturesAndTargets", generator="Immutables")
@Immutable
public final class ImmutableFeaturesAndTargets
implements FeaturesAndTargets {
    private final HugeObjectArray<double[]> features;
    private final HugeDoubleArray targets;

    private ImmutableFeaturesAndTargets(HugeObjectArray<double[]> features, HugeDoubleArray targets) {
        this.features = Objects.requireNonNull(features, "features");
        this.targets = Objects.requireNonNull(targets, "targets");
    }

    private ImmutableFeaturesAndTargets(ImmutableFeaturesAndTargets original, HugeObjectArray<double[]> features, HugeDoubleArray targets) {
        this.features = features;
        this.targets = targets;
    }

    @Override
    public HugeObjectArray<double[]> features() {
        return this.features;
    }

    @Override
    public HugeDoubleArray targets() {
        return this.targets;
    }

    public final ImmutableFeaturesAndTargets withFeatures(HugeObjectArray<double[]> value) {
        if (this.features == value) {
            return this;
        }
        HugeObjectArray<double[]> newValue = Objects.requireNonNull(value, "features");
        return new ImmutableFeaturesAndTargets(this, newValue, this.targets);
    }

    public final ImmutableFeaturesAndTargets withTargets(HugeDoubleArray value) {
        if (this.targets == value) {
            return this;
        }
        HugeDoubleArray newValue = Objects.requireNonNull(value, "targets");
        return new ImmutableFeaturesAndTargets(this, this.features, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeaturesAndTargets && this.equalTo((ImmutableFeaturesAndTargets)another);
    }

    private boolean equalTo(ImmutableFeaturesAndTargets another) {
        return this.features.equals(another.features) && this.targets.equals(another.targets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.features.hashCode();
        h += (h << 5) + this.targets.hashCode();
        return h;
    }

    public String toString() {
        return "FeaturesAndTargets{features=" + this.features + ", targets=" + this.targets + "}";
    }

    public static FeaturesAndTargets of(HugeObjectArray<double[]> features, HugeDoubleArray targets) {
        return new ImmutableFeaturesAndTargets(features, targets);
    }

    static FeaturesAndTargets copyOf(FeaturesAndTargets instance) {
        if (instance instanceof ImmutableFeaturesAndTargets) {
            return (ImmutableFeaturesAndTargets)instance;
        }
        return ImmutableFeaturesAndTargets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeaturesAndTargets", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_FEATURES = 1L;
        private static final long INIT_BIT_TARGETS = 2L;
        private long initBits = 3L;
        @Nullable
        private HugeObjectArray<double[]> features;
        @Nullable
        private HugeDoubleArray targets;

        private Builder() {
        }

        public final Builder from(ImmutableFeaturesAndTargets instance) {
            return this.from((FeaturesAndTargets)instance);
        }

        final Builder from(FeaturesAndTargets instance) {
            Objects.requireNonNull(instance, "instance");
            this.features(instance.features());
            this.targets(instance.targets());
            return this;
        }

        public final Builder features(HugeObjectArray<double[]> features) {
            this.features = Objects.requireNonNull(features, "features");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder targets(HugeDoubleArray targets) {
            this.targets = Objects.requireNonNull(targets, "targets");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.features = null;
            this.targets = null;
            return this;
        }

        public FeaturesAndTargets build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeaturesAndTargets(null, this.features, this.targets);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("features");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targets");
            }
            return "Cannot build FeaturesAndTargets, some of required attributes are not set " + attributes;
        }
    }
}

