/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.ml.linkmodels.ExhaustiveLinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredict;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictCompanion;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictFactory;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

@GdsCallable(name="gds.alpha.ml.linkPrediction.predict.mutate", description="Predicts relationships for all node pairs based on a previously trained link prediction model.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class LinkPredictionPredictMutateProc
extends MutateProc<LinkPredictionPredict, ExhaustiveLinkPredictionResult, MutateResult, LinkPredictionPredictMutateConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphName, configuration));
    }

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for applying a linkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    public ValidationConfiguration<LinkPredictionPredictMutateConfig> validationConfig() {
        return LinkPredictionPredictCompanion.getValidationConfig();
    }

    protected LinkPredictionPredictMutateConfig newConfig(String username, CypherMapWrapper config) {
        return LinkPredictionPredictMutateConfig.of((String)username, (CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictMutateConfig> algorithmFactory() {
        return new LinkPredictionPredictFactory(this.modelCatalog);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(ComputationResult<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig> computeResult, ExecutionContext executionContext) {
        return new MutateResult.Builder();
    }

    public MutateComputationResultConsumer<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig, MutateResult> computationResultConsumer() {
        return new MutateComputationResultConsumer<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig, MutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig> computationResult, ExecutionContext executionContext) {
                Graph graph = computationResult.graph();
                RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((IdMap)graph).orientation(Orientation.UNDIRECTED).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(1).executorService(Pools.DEFAULT).allocationTracker(LinkPredictionPredictMutateProc.this.allocationTracker()).build();
                ((ExhaustiveLinkPredictionResult)computationResult.result()).stream().forEach(predictedLink -> relationshipsBuilder.addFromInternal(graph.toRootNodeId(predictedLink.sourceId()), graph.toRootNodeId(predictedLink.targetId()), predictedLink.probability()));
                Relationships relationships = relationshipsBuilder.build();
                LinkPredictionPredictMutateConfig config = (LinkPredictionPredictMutateConfig)computationResult.config();
                try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
                    computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
                }
                resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
            }
        };
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;

        MutateResult(long preProcessingMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

