/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.spanningtree;

import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.impl.spanningTrees.Prim;
import org.neo4j.gds.impl.spanningTrees.SpanningGraph;
import org.neo4j.gds.impl.spanningTrees.SpanningTree;
import org.neo4j.gds.spanningtree.SpanningTreeConfig;
import org.neo4j.gds.utils.InputNodeValidator;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SpanningTreeProc
extends AlgoBaseProc<Prim, SpanningTree, SpanningTreeConfig> {
    private static final String MIN_DESCRIPTION = "Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.";
    private static final String MAX_DESCRIPTION = "Maximum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is maximized.";
    static DoubleUnaryOperator minMax;
    @Context
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;

    @Procedure(value="gds.alpha.spanningTree.write", mode=Mode.WRITE)
    @Description(value="Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.")
    public Stream<Prim.Result> spanningTree(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MIN_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    @Procedure(value="gds.alpha.spanningTree.minimum.write", mode=Mode.WRITE)
    @Description(value="Minimum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is minimized.")
    public Stream<Prim.Result> minimumSpanningTree(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MIN_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    @Procedure(value="gds.alpha.spanningTree.maximum.write", mode=Mode.WRITE)
    @Description(value="Maximum weight spanning tree visits all nodes that are in the same connected component as the starting node, and returns a spanning tree of all nodes in the component where the total weight of the relationships is maximized.")
    public Stream<Prim.Result> maximumSpanningTree(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MAX_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    private Stream<Prim.Result> computeAndWrite(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        Graph graph = computationResult.graph();
        Prim prim = (Prim)computationResult.algorithm();
        SpanningTree spanningTree = (SpanningTree)computationResult.result();
        SpanningTreeConfig config = (SpanningTreeConfig)computationResult.config();
        Prim.Builder builder = new Prim.Builder();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.build());
        }
        builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount);
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((Prim.Builder)builder).withWriteMillis(arg_0));){
            SpanningGraph spanningGraph = new SpanningGraph(graph, spanningTree);
            TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipExporter.baseTask((String)"SpanningTree", (long)graph.relationshipCount()), this.log, 1, this.taskRegistryFactory);
            this.relationshipExporterBuilder.withGraph((Graph)spanningGraph).withIdMapping((IdMapping)spanningGraph).withTerminationFlag(prim.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).build().write(config.writeProperty(), config.weightWriteProperty());
        }
        builder.withComputeMillis(computationResult.computeMillis());
        builder.withCreateMillis(computationResult.createMillis());
        return Stream.of(builder.build());
    }

    protected SpanningTreeConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SpanningTreeConfig.of(graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<Prim, SpanningTreeConfig> algorithmFactory() {
        return new AlgorithmFactory<Prim, SpanningTreeConfig>(){

            protected String taskName() {
                return "SpanningTree";
            }

            protected Prim build(Graph graph, SpanningTreeConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                InputNodeValidator.validateStartNode(configuration.startNodeId(), graph);
                return new Prim((IdMapping)graph, graph, minMax, configuration.startNodeId(), progressTracker);
            }
        };
    }
}

