/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.scaling;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.scaling.ScaleProperties;
import org.neo4j.gds.scaling.ScalePropertiesFactory;
import org.neo4j.gds.scaling.ScalePropertiesProc;
import org.neo4j.gds.scaling.ScalePropertiesStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ScalePropertiesStreamProc
extends StreamProc<ScaleProperties, ScaleProperties.Result, Result, ScalePropertiesStreamConfig> {
    @Procedure(value="gds.alpha.scaleProperties.stream")
    @Description(value="Scale node properties")
    public Stream<Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<ScaleProperties, ScaleProperties.Result, ScalePropertiesStreamConfig> computationResult) {
        return ScalePropertiesProc.nodeProperties(computationResult);
    }

    protected Map<String, Class<?>> sharedConfigKeys() {
        return Map.of("nodeProperties", Object.class);
    }

    protected ScalePropertiesStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ScalePropertiesStreamConfig.of(graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<ScaleProperties, ScalePropertiesStreamConfig> algorithmFactory() {
        return new ScalePropertiesFactory();
    }

    protected Result streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        return new Result(originalNodeId, nodeProperties.doubleArrayValue(internalNodeId));
    }

    public static class Result {
        public final long nodeId;
        public final List<Double> scaledProperty;

        public Result(long nodeId, double[] scaledProperty) {
            this.nodeId = nodeId;
            this.scaledProperty = Arrays.stream(scaledProperty).boxed().collect(Collectors.toList());
        }
    }
}

