/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.SingleThreadedRandomSeedConfig;
import org.neo4j.gds.core.MissingParameterExceptions;
import org.neo4j.gds.model.ModelConfig;
import org.neo4j.gds.similarity.knn.ImmutableKnnBaseConfig;
import org.neo4j.gds.similarity.knn.KnnBaseConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@Configuration
public interface LinkPredictionPredictPipelineBaseConfig
extends AlgoBaseConfig,
SingleThreadedRandomSeedConfig,
ModelConfig {
    public static final double DEFAULT_THRESHOLD = 0.0;

    @Value.Default
    @Configuration.DoubleRange(min=0.0, max=1.0, minInclusive=false)
    default public double sampleRate() {
        return 1.0;
    }

    @Configuration.IntegerRange(min=1)
    public Optional<Integer> topN();

    @Configuration.DoubleRange(min=0.0, max=1.0)
    public Optional<Double> threshold();

    @Configuration.IntegerRange(min=1)
    public Optional<Integer> topK();

    @Configuration.DoubleRange(min=0.0, max=1.0)
    public Optional<Double> deltaThreshold();

    @Configuration.IntegerRange(min=1)
    public Optional<Integer> maxIterations();

    @Configuration.IntegerRange(min=0)
    public Optional<Integer> randomJoins();

    @Value.Check
    default public void validateParameterCombinations() {
        if (this.isApproximateStrategy()) {
            Map<String, Boolean> exhaustiveStrategyParameters = Map.of("topN", this.topN().isPresent(), "threshold", this.threshold().isPresent());
            this.validateStrategySpecificParameters(exhaustiveStrategyParameters, "equal to 1");
        } else {
            Map<String, Boolean> approximateStrategyParameters = Map.of("topK", this.topK().isPresent(), "deltaThreshold", this.deltaThreshold().isPresent(), "maxIterations", this.maxIterations().isPresent(), "randomJoins", this.randomJoins().isPresent());
            this.validateStrategySpecificParameters(approximateStrategyParameters, "less than 1");
            this.topN().orElseThrow(() -> MissingParameterExceptions.missingValueFor((String)"topN", Collections.emptyList()));
        }
    }

    @Configuration.Ignore
    default public void validateStrategySpecificParameters(Map<String, Boolean> forbiddenParameters, String errorMsg) {
        List definedIllegalParameters = forbiddenParameters.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!definedIllegalParameters.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters %s may only be set if parameter 'sampleRate' is %s.", (Object[])new Object[]{StringJoining.join(definedIllegalParameters), errorMsg}));
        }
    }

    @Configuration.Ignore
    default public KnnBaseConfig approximateConfig() {
        if (!this.isApproximateStrategy()) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Cannot derive approximateConfig when 'sampleRate' is 1.", (Object[])new Object[0]));
        }
        ImmutableKnnBaseConfig.Builder knnBuilder = ImmutableKnnBaseConfig.builder().sampleRate(this.sampleRate()).nodeWeightProperty("NotUsedInLP").minBatchSize(10).concurrency(this.concurrency());
        this.topK().ifPresent(arg_0 -> ((ImmutableKnnBaseConfig.Builder)knnBuilder).topK(arg_0));
        this.deltaThreshold().ifPresent(arg_0 -> ((ImmutableKnnBaseConfig.Builder)knnBuilder).deltaThreshold(arg_0));
        this.maxIterations().ifPresent(arg_0 -> ((ImmutableKnnBaseConfig.Builder)knnBuilder).maxIterations(arg_0));
        this.randomJoins().ifPresent(arg_0 -> ((ImmutableKnnBaseConfig.Builder)knnBuilder).randomJoins(arg_0));
        this.randomSeed().ifPresent(arg_0 -> ((ImmutableKnnBaseConfig.Builder)knnBuilder).randomSeed(arg_0));
        return knnBuilder.build();
    }

    @Configuration.Ignore
    @Value.Derived
    default public double thresholdOrDefault() {
        return this.threshold().orElse(0.0);
    }

    @Configuration.Ignore
    @Value.Derived
    default public boolean isApproximateStrategy() {
        return this.sampleRate() < 1.0;
    }
}

