/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.core.tensor.Matrix;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureExtractor;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionPredictor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionSimilarityComputer;

public abstract class LinkPrediction
extends Algorithm<LinkPrediction, LinkPredictionResult> {
    static final int MIN_NODE_BATCH_SIZE = 10;
    private final LinkLogisticRegressionData modelData;
    private final LinkFeatureExtractor linkFeatureExtractor;
    private final Graph graph;
    protected final int concurrency;

    LinkPrediction(LinkLogisticRegressionData modelData, LinkFeatureExtractor linkFeatureExtractor, Graph graph, int concurrency, ProgressTracker progressTracker) {
        super(progressTracker);
        this.modelData = modelData;
        this.linkFeatureExtractor = linkFeatureExtractor;
        this.graph = graph;
        this.concurrency = concurrency;
    }

    public LinkPredictionResult compute() {
        this.progressTracker.beginSubTask();
        LinkPredictionResult result = this.predict();
        this.progressTracker.endSubTask();
        return result;
    }

    private LinkPredictionResult predict() {
        assert (this.linkFeatureExtractor.featureDimension() == ((Matrix)this.modelData.weights().data()).totalSize()) : "Model must contain a weight for each feature.";
        LinkLogisticRegressionPredictor predictor = new LinkLogisticRegressionPredictor(this.modelData);
        LinkPredictionSimilarityComputer linkPredictionSimilarityComputer = new LinkPredictionSimilarityComputer(this.linkFeatureExtractor, predictor, this.graph);
        return this.predictLinks(this.graph, linkPredictionSimilarityComputer);
    }

    abstract LinkPredictionResult predictLinks(Graph var1, LinkPredictionSimilarityComputer var2);

    public LinkPrediction me() {
        return this;
    }

    public void release() {
    }
}

