/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfig;

public final class LinkPredictionSplitConfigImpl
implements LinkPredictionSplitConfig {
    private int validationFolds;
    private double testFraction;
    private double trainFraction;
    private double negativeSamplingRatio;

    public LinkPredictionSplitConfigImpl(@NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.validationFolds = config.getInt("validationFolds", LinkPredictionSplitConfig.super.validationFolds());
            CypherMapWrapper.validateIntegerRange((String)"validationFolds", (int)this.validationFolds, (int)2, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.testFraction = config.getDouble("testFraction", LinkPredictionSplitConfig.super.testFraction());
            CypherMapWrapper.validateDoubleRange((String)"testFraction", (double)this.testFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.trainFraction = config.getDouble("trainFraction", LinkPredictionSplitConfig.super.trainFraction());
            CypherMapWrapper.validateDoubleRange((String)"trainFraction", (double)this.trainFraction, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.negativeSamplingRatio = config.getDouble("negativeSamplingRatio", LinkPredictionSplitConfig.super.negativeSamplingRatio());
            CypherMapWrapper.validateDoubleRange((String)"negativeSamplingRatio", (double)this.negativeSamplingRatio, (double)0.0, (double)Double.MAX_VALUE, (boolean)false, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int validationFolds() {
        return this.validationFolds;
    }

    @Override
    public double testFraction() {
        return this.testFraction;
    }

    @Override
    public double trainFraction() {
        return this.trainFraction;
    }

    @Override
    public double negativeSamplingRatio() {
        return this.negativeSamplingRatio;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("validationFolds", this.validationFolds());
        map.put("testFraction", this.testFraction());
        map.put("trainFraction", this.trainFraction());
        map.put("negativeSamplingRatio", this.negativeSamplingRatio());
        return map;
    }

    @Override
    public Collection<String> configKeys() {
        return Arrays.asList("validationFolds", "testFraction", "trainFraction", "negativeSamplingRatio");
    }
}

