/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionPredictor;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.ml.pipeline.ImmutableGraphFilter;
import org.neo4j.gds.ml.pipeline.Pipeline;
import org.neo4j.gds.ml.pipeline.PipelineExecutor;

public class NodeClassificationPredictPipelineExecutor
extends PipelineExecutor<NodeClassificationPredictPipelineBaseConfig, NodeClassificationPipeline, NodeClassificationResult, NodeClassificationPredictPipelineExecutor> {
    private final NodeLogisticRegressionData modelData;

    public NodeClassificationPredictPipelineExecutor(NodeClassificationPipeline pipeline, NodeClassificationPredictPipelineBaseConfig config, BaseProc caller, GraphStore graphStore, String graphName, ProgressTracker progressTracker, NodeLogisticRegressionData modelData) {
        super((Pipeline)pipeline, (AlgoBaseConfig)config, caller, graphStore, graphName, progressTracker);
        this.modelData = modelData;
    }

    public NodeClassificationPredictPipelineExecutor me() {
        return this;
    }

    public Map<PipelineExecutor.DatasetSplits, PipelineExecutor.GraphFilter> splitDataset() {
        return Map.of(PipelineExecutor.DatasetSplits.FEATURE_INPUT, ImmutableGraphFilter.of((Collection)((NodeClassificationPredictPipelineBaseConfig)this.config).nodeLabelIdentifiers(this.graphStore), (Collection)((NodeClassificationPredictPipelineBaseConfig)this.config).internalRelationshipTypes(this.graphStore)));
    }

    protected NodeClassificationResult execute(Map<PipelineExecutor.DatasetSplits, PipelineExecutor.GraphFilter> dataSplits) {
        Graph graph = this.graphStore.getGraph(((NodeClassificationPredictPipelineBaseConfig)this.config).nodeLabelIdentifiers(this.graphStore), ((NodeClassificationPredictPipelineBaseConfig)this.config).internalRelationshipTypes(this.graphStore), Optional.empty());
        NodeClassificationPredict innerAlgo = new NodeClassificationPredict(new NodeLogisticRegressionPredictor(this.modelData, ((NodeClassificationPipeline)this.pipeline).featureProperties()), graph, ((NodeClassificationPredictPipelineBaseConfig)this.config).batchSize(), ((NodeClassificationPredictPipelineBaseConfig)this.config).concurrency(), ((NodeClassificationPredictPipelineBaseConfig)this.config).includePredictedProbabilities(), ((NodeClassificationPipeline)this.pipeline).featureProperties(), this.caller.allocationTracker, this.progressTracker);
        return innerAlgo.compute();
    }
}

