/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineBaseConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineStreamConfig;
import org.neo4j.gds.model.ModelConfig;

@ParametersAreNonnullByDefault
@Generated(from="LinkPredictionPredictPipelineStreamConfig", generator="Immutables")
@Immutable
public final class ImmutableLinkPredictionPredictPipelineStreamConfig
implements LinkPredictionPredictPipelineStreamConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    @javax.annotation.Nullable
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @javax.annotation.Nullable
    private final GraphCreateConfig implicitCreateConfig;
    @javax.annotation.Nullable
    private final Long randomSeed;
    private final String modelName;
    private final String username;
    private final double sampleRate;
    @javax.annotation.Nullable
    private final Integer topN;
    @javax.annotation.Nullable
    private final Double threshold;
    @javax.annotation.Nullable
    private final Integer topK;
    @javax.annotation.Nullable
    private final Double deltaThreshold;
    @javax.annotation.Nullable
    private final Integer maxIterations;
    @javax.annotation.Nullable
    private final Integer randomJoins;
    private final double thresholdOrDefault;
    private final boolean isApproximateStrategy;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLinkPredictionPredictPipelineStreamConfig(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, Optional<Long> randomSeed, String modelName, String username, double sampleRate, Optional<Integer> topN, Optional<Double> threshold, Optional<Integer> topK, Optional<Double> deltaThreshold, Optional<Integer> maxIterations, Optional<Integer> randomJoins) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.randomSeed = randomSeed.orElse(null);
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.sampleRate(sampleRate);
        this.topN = topN.orElse(null);
        this.threshold = threshold.orElse(null);
        this.topK = topK.orElse(null);
        this.deltaThreshold = deltaThreshold.orElse(null);
        this.maxIterations = maxIterations.orElse(null);
        this.randomJoins = randomJoins.orElse(null);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.sampleRate = this.initShim.sampleRate();
        this.thresholdOrDefault = this.initShim.thresholdOrDefault();
        this.isApproximateStrategy = this.initShim.isApproximateStrategy();
        this.initShim = null;
    }

    private ImmutableLinkPredictionPredictPipelineStreamConfig(int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, @javax.annotation.Nullable Long randomSeed, String modelName, String username, double sampleRate, @javax.annotation.Nullable Integer topN, @javax.annotation.Nullable Double threshold, @javax.annotation.Nullable Integer topK, @javax.annotation.Nullable Double deltaThreshold, @javax.annotation.Nullable Integer maxIterations, @javax.annotation.Nullable Integer randomJoins) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.randomSeed = randomSeed;
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.sampleRate(sampleRate);
        this.topN = topN;
        this.threshold = threshold;
        this.topK = topK;
        this.deltaThreshold = deltaThreshold;
        this.maxIterations = maxIterations;
        this.randomJoins = randomJoins;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.sampleRate = this.initShim.sampleRate();
        this.thresholdOrDefault = this.initShim.thresholdOrDefault();
        this.isApproximateStrategy = this.initShim.isApproximateStrategy();
        this.initShim = null;
    }

    private ImmutableLinkPredictionPredictPipelineStreamConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.randomSeed = builder.randomSeed;
        this.modelName = builder.modelName;
        this.topN = builder.topN;
        this.threshold = builder.threshold;
        this.topK = builder.topK;
        this.deltaThreshold = builder.deltaThreshold;
        this.maxIterations = builder.maxIterations;
        this.randomJoins = builder.randomJoins;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.sampleRateIsSet()) {
            this.initShim.sampleRate(builder.sampleRate);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.sampleRate = this.initShim.sampleRate();
        this.thresholdOrDefault = this.initShim.thresholdOrDefault();
        this.isApproximateStrategy = this.initShim.isApproximateStrategy();
        this.initShim = null;
    }

    private ImmutableLinkPredictionPredictPipelineStreamConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, List<String> relationshipTypes, List<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, @javax.annotation.Nullable Long randomSeed, String modelName, String username, double sampleRate, @javax.annotation.Nullable Integer topN, @javax.annotation.Nullable Double threshold, @javax.annotation.Nullable Integer topK, @javax.annotation.Nullable Double deltaThreshold, @javax.annotation.Nullable Integer maxIterations, @javax.annotation.Nullable Integer randomJoins) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.randomSeed = randomSeed;
        this.modelName = modelName;
        this.initShim.username(username);
        this.initShim.sampleRate(sampleRate);
        this.topN = topN;
        this.threshold = threshold;
        this.topK = topK;
        this.deltaThreshold = deltaThreshold;
        this.maxIterations = maxIterations;
        this.randomJoins = randomJoins;
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.sampleRate = this.initShim.sampleRate();
        this.thresholdOrDefault = this.initShim.thresholdOrDefault();
        this.isApproximateStrategy = this.initShim.isApproximateStrategy();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.nodeLabels();
    }

    private String usernameInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.username();
    }

    private double sampleRateInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.sampleRate();
    }

    private double thresholdOrDefaultInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.thresholdOrDefault();
    }

    private boolean isApproximateStrategyInitialize() {
        return LinkPredictionPredictPipelineStreamConfig.super.isApproximateStrategy();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public double sampleRate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sampleRate() : this.sampleRate;
    }

    @Override
    public Optional<Integer> topN() {
        return Optional.ofNullable(this.topN);
    }

    @Override
    public Optional<Double> threshold() {
        return Optional.ofNullable(this.threshold);
    }

    @Override
    public Optional<Integer> topK() {
        return Optional.ofNullable(this.topK);
    }

    @Override
    public Optional<Double> deltaThreshold() {
        return Optional.ofNullable(this.deltaThreshold);
    }

    @Override
    public Optional<Integer> maxIterations() {
        return Optional.ofNullable(this.maxIterations);
    }

    @Override
    public Optional<Integer> randomJoins() {
        return Optional.ofNullable(this.randomJoins);
    }

    @Override
    public double thresholdOrDefault() {
        InitShim shim = this.initShim;
        return shim != null ? shim.thresholdOrDefault() : this.thresholdOrDefault;
    }

    @Override
    public boolean isApproximateStrategy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isApproximateStrategy() : this.isApproximateStrategy;
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withGraphName(@javax.annotation.Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(elements, true, false));
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(elements, true, false));
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withImplicitCreateConfig(@javax.annotation.Nullable GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRandomSeed(@javax.annotation.Nullable Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, newValue, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, newValue, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, newValue, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withSampleRate(double value) {
        if (Double.doubleToLongBits(this.sampleRate) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, value, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withTopN(@javax.annotation.Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.topN, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, newValue, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withTopN(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.topN, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, value, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withThreshold(@javax.annotation.Nullable Double value) {
        Double newValue = value;
        if (Objects.equals(this.threshold, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, newValue, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withThreshold(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.threshold, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, value, this.topK, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withTopK(@javax.annotation.Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.topK, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, newValue, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withTopK(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.topK, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, value, this.deltaThreshold, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withDeltaThreshold(@javax.annotation.Nullable Double value) {
        Double newValue = value;
        if (Objects.equals(this.deltaThreshold, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, newValue, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withDeltaThreshold(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.deltaThreshold, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, value, this.maxIterations, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withMaxIterations(@javax.annotation.Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.maxIterations, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, newValue, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withMaxIterations(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.maxIterations, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, value, this.randomJoins));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRandomJoins(@javax.annotation.Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.randomJoins, newValue)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, newValue));
    }

    public final ImmutableLinkPredictionPredictPipelineStreamConfig withRandomJoins(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.randomJoins, value)) {
            return this;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.randomSeed, this.modelName, this.username, this.sampleRate, this.topN, this.threshold, this.topK, this.deltaThreshold, this.maxIterations, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionPredictPipelineStreamConfig && this.equalTo((ImmutableLinkPredictionPredictPipelineStreamConfig)another);
    }

    private boolean equalTo(ImmutableLinkPredictionPredictPipelineStreamConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && Objects.equals(this.randomSeed, another.randomSeed) && this.modelName.equals(another.modelName) && this.username.equals(another.username) && Double.doubleToLongBits(this.sampleRate) == Double.doubleToLongBits(another.sampleRate) && Objects.equals(this.topN, another.topN) && Objects.equals(this.threshold, another.threshold) && Objects.equals(this.topK, another.topK) && Objects.equals(this.deltaThreshold, another.deltaThreshold) && Objects.equals(this.maxIterations, another.maxIterations) && Objects.equals(this.randomJoins, another.randomJoins) && Double.doubleToLongBits(this.thresholdOrDefault) == Double.doubleToLongBits(another.thresholdOrDefault) && this.isApproximateStrategy == another.isApproximateStrategy;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Double.hashCode(this.sampleRate);
        h += (h << 5) + Objects.hashCode(this.topN);
        h += (h << 5) + Objects.hashCode(this.threshold);
        h += (h << 5) + Objects.hashCode(this.topK);
        h += (h << 5) + Objects.hashCode(this.deltaThreshold);
        h += (h << 5) + Objects.hashCode(this.maxIterations);
        h += (h << 5) + Objects.hashCode(this.randomJoins);
        h += (h << 5) + Double.hashCode(this.thresholdOrDefault);
        h += (h << 5) + Boolean.hashCode(this.isApproximateStrategy);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LinkPredictionPredictPipelineStreamConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 42) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("sampleRate=").append(this.sampleRate);
        if (this.topN != null) {
            builder.append(", ");
            builder.append("topN=").append(this.topN);
        }
        if (this.threshold != null) {
            builder.append(", ");
            builder.append("threshold=").append(this.threshold);
        }
        if (this.topK != null) {
            builder.append(", ");
            builder.append("topK=").append(this.topK);
        }
        if (this.deltaThreshold != null) {
            builder.append(", ");
            builder.append("deltaThreshold=").append(this.deltaThreshold);
        }
        if (this.maxIterations != null) {
            builder.append(", ");
            builder.append("maxIterations=").append(this.maxIterations);
        }
        if (this.randomJoins != null) {
            builder.append(", ");
            builder.append("randomJoins=").append(this.randomJoins);
        }
        builder.append(", ");
        builder.append("thresholdOrDefault=").append(this.thresholdOrDefault);
        builder.append(", ");
        builder.append("isApproximateStrategy=").append(this.isApproximateStrategy);
        return builder.append("}").toString();
    }

    public static LinkPredictionPredictPipelineStreamConfig of(int concurrency, int minBatchSize, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, Optional<Long> randomSeed, String modelName, String username, double sampleRate, Optional<Integer> topN, Optional<Double> threshold, Optional<Integer> topK, Optional<Double> deltaThreshold, Optional<Integer> maxIterations, Optional<Integer> randomJoins) {
        return ImmutableLinkPredictionPredictPipelineStreamConfig.of(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, randomSeed, modelName, username, sampleRate, topN, threshold, topK, deltaThreshold, maxIterations, randomJoins);
    }

    public static LinkPredictionPredictPipelineStreamConfig of(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, Optional<Long> randomSeed, String modelName, String username, double sampleRate, Optional<Integer> topN, Optional<Double> threshold, Optional<Integer> topK, Optional<Double> deltaThreshold, Optional<Integer> maxIterations, Optional<Integer> randomJoins) {
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, randomSeed, modelName, username, sampleRate, topN, threshold, topK, deltaThreshold, maxIterations, randomJoins));
    }

    public static LinkPredictionPredictPipelineStreamConfig of(int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, @javax.annotation.Nullable Long randomSeed, String modelName, String username, double sampleRate, @javax.annotation.Nullable Integer topN, @javax.annotation.Nullable Double threshold, @javax.annotation.Nullable Integer topK, @javax.annotation.Nullable Double deltaThreshold, @javax.annotation.Nullable Integer maxIterations, @javax.annotation.Nullable Integer randomJoins) {
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, randomSeed, modelName, username, sampleRate, topN, threshold, topK, deltaThreshold, maxIterations, randomJoins));
    }

    private static ImmutableLinkPredictionPredictPipelineStreamConfig validate(ImmutableLinkPredictionPredictPipelineStreamConfig instance) {
        instance.validateParameterCombinations();
        instance.validate();
        instance.validateConcurrency();
        return instance;
    }

    public static LinkPredictionPredictPipelineStreamConfig copyOf(LinkPredictionPredictPipelineStreamConfig instance) {
        if (instance instanceof ImmutableLinkPredictionPredictPipelineStreamConfig) {
            return (ImmutableLinkPredictionPredictPipelineStreamConfig)instance;
        }
        return ImmutableLinkPredictionPredictPipelineStreamConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LinkPredictionPredictPipelineStreamConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SAMPLE_RATE = 64L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        @javax.annotation.Nullable
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        @javax.annotation.Nullable
        private GraphCreateConfig implicitCreateConfig;
        @javax.annotation.Nullable
        private Long randomSeed;
        @javax.annotation.Nullable
        private String modelName;
        @javax.annotation.Nullable
        private String username;
        private double sampleRate;
        @javax.annotation.Nullable
        private Integer topN;
        @javax.annotation.Nullable
        private Double threshold;
        @javax.annotation.Nullable
        private Integer topK;
        @javax.annotation.Nullable
        private Double deltaThreshold;
        @javax.annotation.Nullable
        private Integer maxIterations;
        @javax.annotation.Nullable
        private Integer randomJoins;

        private Builder() {
        }

        public final Builder from(LinkPredictionPredictPipelineBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LinkPredictionPredictPipelineStreamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            LinkPredictionPredictPipelineBaseConfig instance;
            if (object instanceof LinkPredictionPredictPipelineBaseConfig) {
                Optional<Integer> topNOptional;
                Optional<Double> thresholdOptional;
                Optional<Integer> randomJoinsOptional;
                Optional<Integer> maxIterationsOptional;
                instance = (LinkPredictionPredictPipelineBaseConfig)object;
                Optional<Integer> topKOptional = instance.topK();
                if (topKOptional.isPresent()) {
                    this.topK(topKOptional);
                }
                if ((maxIterationsOptional = instance.maxIterations()).isPresent()) {
                    this.maxIterations(maxIterationsOptional);
                }
                if ((randomJoinsOptional = instance.randomJoins()).isPresent()) {
                    this.randomJoins(randomJoinsOptional);
                }
                if ((thresholdOptional = instance.threshold()).isPresent()) {
                    this.threshold(thresholdOptional);
                }
                this.sampleRate(instance.sampleRate());
                Optional<Double> deltaThresholdOptional = instance.deltaThreshold();
                if (deltaThresholdOptional.isPresent()) {
                    this.deltaThreshold(deltaThresholdOptional);
                }
                if ((topNOptional = instance.topN()).isPresent()) {
                    this.topN(topNOptional);
                }
            }
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
                this.username(instance.username());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphName(@javax.annotation.Nullable String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder implicitCreateConfig(@javax.annotation.Nullable GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder randomSeed(@javax.annotation.Nullable Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder sampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder topN(@javax.annotation.Nullable Integer topN) {
            this.topN = topN;
            return this;
        }

        public final Builder topN(Optional<Integer> topN) {
            this.topN = topN.orElse(null);
            return this;
        }

        public final Builder threshold(@javax.annotation.Nullable Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final Builder threshold(Optional<Double> threshold) {
            this.threshold = threshold.orElse(null);
            return this;
        }

        public final Builder topK(@javax.annotation.Nullable Integer topK) {
            this.topK = topK;
            return this;
        }

        public final Builder topK(Optional<Integer> topK) {
            this.topK = topK.orElse(null);
            return this;
        }

        public final Builder deltaThreshold(@javax.annotation.Nullable Double deltaThreshold) {
            this.deltaThreshold = deltaThreshold;
            return this;
        }

        public final Builder deltaThreshold(Optional<Double> deltaThreshold) {
            this.deltaThreshold = deltaThreshold.orElse(null);
            return this;
        }

        public final Builder maxIterations(@javax.annotation.Nullable Integer maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        public final Builder maxIterations(Optional<Integer> maxIterations) {
            this.maxIterations = maxIterations.orElse(null);
            return this;
        }

        public final Builder randomJoins(@javax.annotation.Nullable Integer randomJoins) {
            this.randomJoins = randomJoins;
            return this;
        }

        public final Builder randomJoins(Optional<Integer> randomJoins) {
            this.randomJoins = randomJoins.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.randomSeed = null;
            this.modelName = null;
            this.username = null;
            this.sampleRate = 0.0;
            this.topN = null;
            this.threshold = null;
            this.topK = null;
            this.deltaThreshold = null;
            this.maxIterations = null;
            this.randomJoins = null;
            return this;
        }

        public LinkPredictionPredictPipelineStreamConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLinkPredictionPredictPipelineStreamConfig.validate(new ImmutableLinkPredictionPredictPipelineStreamConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean sampleRateIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            return "Cannot build LinkPredictionPredictPipelineStreamConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LinkPredictionPredictPipelineStreamConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte usernameBuildStage = 0;
        private String username;
        private byte sampleRateBuildStage = 0;
        private double sampleRate;
        private byte thresholdOrDefaultBuildStage = 0;
        private double thresholdOrDefault;
        private byte isApproximateStrategyBuildStage = 0;
        private boolean isApproximateStrategy;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableLinkPredictionPredictPipelineStreamConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableLinkPredictionPredictPipelineStreamConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableLinkPredictionPredictPipelineStreamConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableLinkPredictionPredictPipelineStreamConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableLinkPredictionPredictPipelineStreamConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableLinkPredictionPredictPipelineStreamConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(ImmutableLinkPredictionPredictPipelineStreamConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableLinkPredictionPredictPipelineStreamConfig.createUnmodifiableList(false, ImmutableLinkPredictionPredictPipelineStreamConfig.createSafeList(ImmutableLinkPredictionPredictPipelineStreamConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableLinkPredictionPredictPipelineStreamConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        double sampleRate() {
            if (this.sampleRateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sampleRateBuildStage == 0) {
                this.sampleRateBuildStage = (byte)-1;
                this.sampleRate = ImmutableLinkPredictionPredictPipelineStreamConfig.this.sampleRateInitialize();
                this.sampleRateBuildStage = 1;
            }
            return this.sampleRate;
        }

        void sampleRate(double sampleRate) {
            this.sampleRate = sampleRate;
            this.sampleRateBuildStage = 1;
        }

        double thresholdOrDefault() {
            if (this.thresholdOrDefaultBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.thresholdOrDefaultBuildStage == 0) {
                this.thresholdOrDefaultBuildStage = (byte)-1;
                this.thresholdOrDefault = ImmutableLinkPredictionPredictPipelineStreamConfig.this.thresholdOrDefaultInitialize();
                this.thresholdOrDefaultBuildStage = 1;
            }
            return this.thresholdOrDefault;
        }

        boolean isApproximateStrategy() {
            if (this.isApproximateStrategyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isApproximateStrategyBuildStage == 0) {
                this.isApproximateStrategyBuildStage = (byte)-1;
                this.isApproximateStrategy = ImmutableLinkPredictionPredictPipelineStreamConfig.this.isApproximateStrategyInitialize();
                this.isApproximateStrategyBuildStage = 1;
            }
            return this.isApproximateStrategy;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.sampleRateBuildStage == -1) {
                attributes.add("sampleRate");
            }
            if (this.thresholdOrDefaultBuildStage == -1) {
                attributes.add("thresholdOrDefault");
            }
            if (this.isApproximateStrategyBuildStage == -1) {
                attributes.add("isApproximateStrategy");
            }
            return "Cannot build LinkPredictionPredictPipelineStreamConfig, attribute initializers form cycle " + attributes;
        }
    }
}

