/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.gds.pregel.proc.PregelWriteProc;
import org.neo4j.gds.pregel.proc.PregelWriteResult;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class HitsWriteProc
extends PregelWriteProc<HitsAlgorithm, Hits.HitsConfig> {
    @Procedure(name="gds.alpha.hits.write", mode=Mode.WRITE)
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelWriteResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.hits.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> writeEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<PregelWriteResult> resultBuilder(AlgoBaseProc.ComputationResult<HitsAlgorithm, PregelResult, Hits.HitsConfig> computeResult) {
        int ranIterations = ((PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((PregelResult)computeResult.result()).didConverge();
        return new PregelWriteResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected Hits.HitsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return Hits.HitsConfig.of(graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<HitsAlgorithm, Hits.HitsConfig> algorithmFactory() {
        return new AlgorithmFactory<HitsAlgorithm, Hits.HitsConfig>(){

            public HitsAlgorithm build(Graph graph, Hits.HitsConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new HitsAlgorithm(graph, configuration, allocationTracker, progressTracker);
            }

            protected String taskName() {
                return HitsAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, Hits.HitsConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(Hits.HitsConfig configuration) {
                Hits computation = new Hits();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isPresent(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

