/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.GraphStoreValidation;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineMutateProc
extends MutatePropertyProc<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, MutateResult, NodeClassificationPredictPipelineMutateConfig> {
    static final String DESCRIPTION = "Predicts classes for all nodes based on a previously trained pipeline model";
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, NodeClassificationPredictPipelineMutateConfig config) {
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
        config.predictedProbabilityProperty().ifPresent(property -> GraphStoreValidation.validateNodePropertyDoesNotExist((GraphStore)graphStore, (Collection)config.nodeLabelIdentifiers(graphStore), (String)property));
        config.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
            if (config.mutateProperty().equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
    }

    protected List<NodeProperty> nodePropertyList(AlgoBaseProc.ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineMutateConfig> computationResult) {
        NodeClassificationPredictPipelineMutateConfig config = (NodeClassificationPredictPipelineMutateConfig)computationResult.config();
        String mutateProperty = config.mutateProperty();
        NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)mutateProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((AlgoBaseProc.ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ AlgoBaseProc.ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)config.predictedProbabilityProperty().orElseThrow(), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected NodeClassificationPredictPipelineMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationPredictPipelineMutateConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<NodeClassificationPredictPipelineExecutor, NodeClassificationPredictPipelineMutateConfig> algorithmFactory() {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineMutateConfig>((BaseProc)this, this.databaseId(), this.modelCatalog);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

