/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.nodemodels.MetricData;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.nodemodels.metrics.Metric;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineModelInfo;

@ParametersAreNonnullByDefault
@Generated(from="NodeClassificationPipelineModelInfo", generator="Immutables")
@Immutable
public final class ImmutableNodeClassificationPipelineModelInfo
implements NodeClassificationPipelineModelInfo {
    private final NodeClassificationPipeline trainingPipeline;
    private final List<Long> classes;
    private final NodeLogisticRegressionTrainConfig bestParameters;
    private final Map<Metric, MetricData<NodeLogisticRegressionTrainConfig>> metrics;
    private final transient Map<String, Object> toMap;

    private ImmutableNodeClassificationPipelineModelInfo(NodeClassificationPipeline trainingPipeline, Iterable<Long> classes, NodeLogisticRegressionTrainConfig bestParameters, Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> metrics) {
        this.trainingPipeline = Objects.requireNonNull(trainingPipeline, "trainingPipeline");
        this.classes = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, ImmutableNodeClassificationPipelineModelInfo.createSafeList(classes, true, false));
        this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
        this.metrics = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(true, false, metrics);
        this.toMap = Objects.requireNonNull(NodeClassificationPipelineModelInfo.super.toMap(), "toMap");
    }

    private ImmutableNodeClassificationPipelineModelInfo(ImmutableNodeClassificationPipelineModelInfo original, NodeClassificationPipeline trainingPipeline, List<Long> classes, NodeLogisticRegressionTrainConfig bestParameters, Map<Metric, MetricData<NodeLogisticRegressionTrainConfig>> metrics) {
        this.trainingPipeline = trainingPipeline;
        this.classes = classes;
        this.bestParameters = bestParameters;
        this.metrics = metrics;
        this.toMap = Objects.requireNonNull(NodeClassificationPipelineModelInfo.super.toMap(), "toMap");
    }

    @Override
    public NodeClassificationPipeline trainingPipeline() {
        return this.trainingPipeline;
    }

    @Override
    public List<Long> classes() {
        return this.classes;
    }

    @Override
    public NodeLogisticRegressionTrainConfig bestParameters() {
        return this.bestParameters;
    }

    @Override
    public Map<Metric, MetricData<NodeLogisticRegressionTrainConfig>> metrics() {
        return this.metrics;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    public final ImmutableNodeClassificationPipelineModelInfo withTrainingPipeline(NodeClassificationPipeline value) {
        if (this.trainingPipeline == value) {
            return this;
        }
        NodeClassificationPipeline newValue = Objects.requireNonNull(value, "trainingPipeline");
        return new ImmutableNodeClassificationPipelineModelInfo(this, newValue, this.classes, this.bestParameters, this.metrics);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withClasses(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, wrappedList);
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.trainingPipeline, newValue, this.bestParameters, this.metrics);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withClasses(Iterable<Long> elements) {
        if (this.classes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(false, ImmutableNodeClassificationPipelineModelInfo.createSafeList(elements, true, false));
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.trainingPipeline, newValue, this.bestParameters, this.metrics);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withBestParameters(NodeLogisticRegressionTrainConfig value) {
        if (this.bestParameters == value) {
            return this;
        }
        NodeLogisticRegressionTrainConfig newValue = Objects.requireNonNull(value, "bestParameters");
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.trainingPipeline, this.classes, newValue, this.metrics);
    }

    public final ImmutableNodeClassificationPipelineModelInfo withMetrics(Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> entries) {
        if (this.metrics == entries) {
            return this;
        }
        Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> newValue = ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableNodeClassificationPipelineModelInfo(this, this.trainingPipeline, this.classes, this.bestParameters, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPipelineModelInfo && this.equalTo((ImmutableNodeClassificationPipelineModelInfo)another);
    }

    private boolean equalTo(ImmutableNodeClassificationPipelineModelInfo another) {
        return ((Object)((Object)this.trainingPipeline)).equals((Object)another.trainingPipeline) && this.classes.equals(another.classes) && this.bestParameters.equals(another.bestParameters) && this.metrics.equals(another.metrics);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + ((Object)((Object)this.trainingPipeline)).hashCode();
        h += (h << 5) + this.classes.hashCode();
        h += (h << 5) + this.bestParameters.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        return h;
    }

    public String toString() {
        return "NodeClassificationPipelineModelInfo{trainingPipeline=" + this.trainingPipeline + ", classes=" + this.classes + ", bestParameters=" + this.bestParameters + ", metrics=" + this.metrics + "}";
    }

    public static NodeClassificationPipelineModelInfo of(NodeClassificationPipeline trainingPipeline, List<Long> classes, NodeLogisticRegressionTrainConfig bestParameters, Map<Metric, MetricData<NodeLogisticRegressionTrainConfig>> metrics) {
        return ImmutableNodeClassificationPipelineModelInfo.of(trainingPipeline, classes, bestParameters, metrics);
    }

    public static NodeClassificationPipelineModelInfo of(NodeClassificationPipeline trainingPipeline, Iterable<Long> classes, NodeLogisticRegressionTrainConfig bestParameters, Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> metrics) {
        return new ImmutableNodeClassificationPipelineModelInfo(trainingPipeline, classes, bestParameters, metrics);
    }

    public static NodeClassificationPipelineModelInfo copyOf(NodeClassificationPipelineModelInfo instance) {
        if (instance instanceof ImmutableNodeClassificationPipelineModelInfo) {
            return (ImmutableNodeClassificationPipelineModelInfo)instance;
        }
        return ImmutableNodeClassificationPipelineModelInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodeClassificationPipelineModelInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRAINING_PIPELINE = 1L;
        private static final long INIT_BIT_BEST_PARAMETERS = 2L;
        private long initBits = 3L;
        @Nullable
        private NodeClassificationPipeline trainingPipeline;
        private List<Long> classes = null;
        @Nullable
        private NodeLogisticRegressionTrainConfig bestParameters;
        private Map<Metric, MetricData<NodeLogisticRegressionTrainConfig>> metrics = null;

        private Builder() {
        }

        public final Builder from(NodeClassificationPipelineModelInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.trainingPipeline(instance.trainingPipeline());
            this.addAllClasses(instance.classes());
            this.bestParameters(instance.bestParameters());
            this.putAllMetrics(instance.metrics());
            return this;
        }

        public final Builder trainingPipeline(NodeClassificationPipeline trainingPipeline) {
            this.trainingPipeline = Objects.requireNonNull(trainingPipeline, "trainingPipeline");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addClasse(long element) {
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            this.classes.add(element);
            return this;
        }

        public final Builder addClasses(long ... elements) {
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.classes.add(element);
            }
            return this;
        }

        public final Builder classes(Iterable<Long> elements) {
            this.classes = new ArrayList<Long>();
            return this.addAllClasses(elements);
        }

        public final Builder addAllClasses(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "classes element");
            if (this.classes == null) {
                this.classes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.classes.add(Objects.requireNonNull(Long.valueOf(element), "classes element"));
            }
            return this;
        }

        public final Builder bestParameters(NodeLogisticRegressionTrainConfig bestParameters) {
            this.bestParameters = Objects.requireNonNull(bestParameters, "bestParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putMetric(Metric key, MetricData<NodeLogisticRegressionTrainConfig> value) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<Metric, MetricData<NodeLogisticRegressionTrainConfig>>();
            }
            this.metrics.put(Objects.requireNonNull(key, "metrics key"), Objects.requireNonNull(value, "metrics value"));
            return this;
        }

        public final Builder putMetric(Map.Entry<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> entry) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<Metric, MetricData<NodeLogisticRegressionTrainConfig>>();
            }
            Metric k = entry.getKey();
            MetricData<NodeLogisticRegressionTrainConfig> v = entry.getValue();
            this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            return this;
        }

        public final Builder metrics(Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> entries) {
            this.metrics = new LinkedHashMap<Metric, MetricData<NodeLogisticRegressionTrainConfig>>();
            return this.putAllMetrics(entries);
        }

        public final Builder putAllMetrics(Map<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> entries) {
            if (this.metrics == null) {
                this.metrics = new LinkedHashMap<Metric, MetricData<NodeLogisticRegressionTrainConfig>>();
            }
            for (Map.Entry<? extends Metric, ? extends MetricData<NodeLogisticRegressionTrainConfig>> e : entries.entrySet()) {
                Metric k = e.getKey();
                MetricData<NodeLogisticRegressionTrainConfig> v = e.getValue();
                this.metrics.put(Objects.requireNonNull(k, "metrics key"), Objects.requireNonNull(v, "metrics value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.trainingPipeline = null;
            if (this.classes != null) {
                this.classes.clear();
            }
            this.bestParameters = null;
            if (this.metrics != null) {
                this.metrics.clear();
            }
            return this;
        }

        public NodeClassificationPipelineModelInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeClassificationPipelineModelInfo(null, this.trainingPipeline, this.classes == null ? Collections.emptyList() : ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableList(true, this.classes), this.bestParameters, this.metrics == null ? Collections.emptyMap() : ImmutableNodeClassificationPipelineModelInfo.createUnmodifiableMap(false, false, this.metrics));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("trainingPipeline");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bestParameters");
            }
            return "Cannot build NodeClassificationPipelineModelInfo, some of required attributes are not set " + attributes;
        }
    }
}

