/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.metrics.LinkMetric;
import org.neo4j.gds.ml.linkmodels.pipeline.train.ImmutableLinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfigImpl;
import org.neo4j.gds.model.ModelConfig;

@ValueClass
@Configuration
public interface LinkPredictionTrainConfig
extends AlgoBaseConfig,
ModelConfig,
RandomSeedConfig {
    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double negativeClassWeight() {
        return 1.0;
    }

    public String pipeline();

    @Configuration.Ignore
    @Value.Default
    default public List<LinkMetric> metrics() {
        return List.of(LinkMetric.AUCPR);
    }

    public static LinkPredictionTrainConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new LinkPredictionTrainConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    public static ImmutableLinkPredictionTrainConfig.Builder builder() {
        return ImmutableLinkPredictionTrainConfig.builder();
    }
}

