/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.Map;
import java.util.Optional;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.HdrHistogram.ConcurrentDoubleHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.result.HistogramUtils;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

public class LinkPredictionPipelineMutateProc
extends MutateProc<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, MutateResult, LinkPredictionPredictPipelineMutateConfig> {
    static final String DESCRIPTION = "Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.";
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all non-connected node pairs based on a previously trained Link prediction pipeline.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionPredictPipelineMutateConfig config) {
        super.validateConfigsBeforeLoad(graphCreateConfig, (AlgoBaseConfig)config);
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computeResult) {
        MutateResult.Builder builder = new MutateResult.Builder().withSamplingStats(((LinkPredictionResult)computeResult.result()).samplingStats());
        if (this.callContext.outputFields().anyMatch(s -> s.equalsIgnoreCase("probabilityDistribution"))) {
            builder.withHistogram();
        }
        return builder;
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<LinkPredictionPredictPipelineExecutor, LinkPredictionResult, LinkPredictionPredictPipelineMutateConfig> computationResult) {
        Graph graph = computationResult.graph();
        int concurrency = ((LinkPredictionPredictPipelineMutateConfig)computationResult.config()).concurrency();
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((IdMapping)graph).orientation(Orientation.UNDIRECTED).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(concurrency).executorService(Pools.DEFAULT).allocationTracker(this.allocationTracker()).build();
        MutateResult.Builder resultWithHistogramBuilder = (MutateResult.Builder)resultBuilder;
        ParallelUtil.parallelStreamConsume((BaseStream)((LinkPredictionResult)computationResult.result()).stream(), (int)concurrency, stream -> stream.forEach(predictedLink -> {
            relationshipsBuilder.addFromInternal(graph.toRootNodeId(predictedLink.sourceId()), graph.toRootNodeId(predictedLink.targetId()), predictedLink.probability());
            resultWithHistogramBuilder.recordHistogramValue(predictedLink.probability());
        }));
        Relationships relationships = relationshipsBuilder.build();
        LinkPredictionPredictPipelineMutateConfig config = (LinkPredictionPredictPipelineMutateConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
        }
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }

    protected LinkPredictionPredictPipelineMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPredictPipelineMutateConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<LinkPredictionPredictPipelineExecutor, LinkPredictionPredictPipelineMutateConfig> algorithmFactory() {
        return new LinkPredictionPredictPipelineAlgorithmFactory<LinkPredictionPredictPipelineMutateConfig>((BaseProc)this, this.databaseId(), this.modelCatalog);
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;
        public final Map<String, Object> probabilityDistribution;
        public final Map<String, Object> samplingStats;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration, Map<String, Object> probabilityDistribution, Map<String, Object> samplingStats) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
            this.probabilityDistribution = probabilityDistribution;
            this.samplingStats = samplingStats;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            private Map<String, Object> samplingStats = null;
            @Nullable
            private ConcurrentDoubleHistogram histogram = null;

            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap(), this.histogram == null ? Map.of() : HistogramUtils.similaritySummary((DoubleHistogram)this.histogram), this.samplingStats);
            }

            Builder withHistogram() {
                if (this.histogram != null) {
                    return this;
                }
                this.histogram = new ConcurrentDoubleHistogram(5);
                return this;
            }

            void recordHistogramValue(double value) {
                if (this.histogram == null) {
                    return;
                }
                this.histogram.recordValue(value);
            }

            Builder withSamplingStats(Map<String, Object> samplingStats) {
                this.samplingStats = samplingStats;
                return this;
            }
        }
    }
}

