/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.ml.linkmodels.pipeline.ImmutableLinkPredictionSplitConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfigImpl;
import org.neo4j.gds.ml.splitting.SplitRelationshipsBaseConfig;
import org.neo4j.gds.ml.splitting.SplitRelationshipsBaseConfigImpl;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@ValueClass
@Configuration
public interface LinkPredictionSplitConfig
extends ToMapConvertible {
    public static final String TEST_FRACTION_KEY = "testFraction";
    public static final String TRAIN_FRACTION_KEY = "trainFraction";
    public static final LinkPredictionSplitConfig DEFAULT_CONFIG = LinkPredictionSplitConfig.of(CypherMapWrapper.empty());

    @Value.Default
    @Configuration.IntegerRange(min=2)
    default public int validationFolds() {
        return 3;
    }

    @Value.Default
    @Configuration.Key(value="testFraction")
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double testFraction() {
        return 0.1;
    }

    @Value.Default
    @Configuration.Key(value="trainFraction")
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double trainFraction() {
        return 0.1;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0, minInclusive=false)
    default public double negativeSamplingRatio() {
        return 1.0;
    }

    @Value.Default
    @Configuration.Ignore
    default public String testRelationshipType() {
        return "_TEST_";
    }

    @Value.Default
    @Configuration.Ignore
    default public String testComplementRelationshipType() {
        return "_TEST_COMPLEMENT_";
    }

    @Value.Default
    @Configuration.Ignore
    default public String trainRelationshipType() {
        return "_TRAIN_";
    }

    @Value.Default
    @Configuration.Ignore
    default public String featureInputRelationshipType() {
        return "_FEATURE_INPUT_";
    }

    @Configuration.ToMap
    public Map<String, Object> toMap();

    @Configuration.CollectKeys
    default public Collection<String> configKeys() {
        return Collections.emptyList();
    }

    @Value.Derived
    @Configuration.Ignore
    default public SplitRelationshipsBaseConfig testSplit() {
        return new SplitRelationshipsBaseConfigImpl(CypherMapWrapper.create(Map.of("holdoutRelationshipType", this.testRelationshipType(), "remainingRelationshipType", this.testComplementRelationshipType(), "holdOutFraction", this.testFraction(), "negativeSamplingRatio", this.negativeSamplingRatio())));
    }

    @Value.Derived
    @Configuration.Ignore
    default public SplitRelationshipsBaseConfig trainSplit() {
        return new SplitRelationshipsBaseConfigImpl(CypherMapWrapper.create(Map.of("holdoutRelationshipType", this.trainRelationshipType(), "remainingRelationshipType", this.featureInputRelationshipType(), "holdOutFraction", this.trainFraction(), "negativeSamplingRatio", this.negativeSamplingRatio())));
    }

    public static LinkPredictionSplitConfig of(CypherMapWrapper config) {
        return new LinkPredictionSplitConfigImpl(config);
    }

    public static ImmutableLinkPredictionSplitConfig.Builder builder() {
        return ImmutableLinkPredictionSplitConfig.builder();
    }

    @Configuration.Ignore
    default public void validateAgainstGraphStore(GraphStore graphStore) {
        Stream<String> reservedTypes = Stream.of(this.testRelationshipType(), this.trainRelationshipType(), this.featureInputRelationshipType(), this.testComplementRelationshipType());
        List invalidTypes = reservedTypes.filter(reservedType -> graphStore.hasRelationshipType(RelationshipType.of((String)reservedType))).collect(Collectors.toList());
        if (!invalidTypes.isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The relationship types %s are in the input graph, but are reserved for splitting.", (Object[])new Object[]{StringJoining.join(invalidTypes)}));
        }
    }
}

