/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.influence\u039caximization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.influence\u039caximization.InfluenceMaximizationConfig;

@ParametersAreNonnullByDefault
@Generated(from="InfluenceMaximizationConfig", generator="Immutables")
@Immutable
public final class ImmutableInfluenceMaximizationConfig
implements InfluenceMaximizationConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    @javax.annotation.Nullable
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @javax.annotation.Nullable
    private final GraphCreateConfig implicitCreateConfig;
    private final int seedSetSize;
    private final double propagationProbability;
    private final int monteCarloSimulations;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInfluenceMaximizationConfig(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.seedSetSize = seedSetSize;
        this.initShim.propagationProbability(propagationProbability);
        this.initShim.monteCarloSimulations(monteCarloSimulations);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.propagationProbability = this.initShim.propagationProbability();
        this.monteCarloSimulations = this.initShim.monteCarloSimulations();
        this.initShim = null;
    }

    private ImmutableInfluenceMaximizationConfig(int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.seedSetSize = seedSetSize;
        this.initShim.propagationProbability(propagationProbability);
        this.initShim.monteCarloSimulations(monteCarloSimulations);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.propagationProbability = this.initShim.propagationProbability();
        this.monteCarloSimulations = this.initShim.monteCarloSimulations();
        this.initShim = null;
    }

    private ImmutableInfluenceMaximizationConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.seedSetSize = builder.seedSetSize;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableInfluenceMaximizationConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableInfluenceMaximizationConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.propagationProbabilityIsSet()) {
            this.initShim.propagationProbability(builder.propagationProbability);
        }
        if (builder.monteCarloSimulationsIsSet()) {
            this.initShim.monteCarloSimulations(builder.monteCarloSimulations);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.propagationProbability = this.initShim.propagationProbability();
        this.monteCarloSimulations = this.initShim.monteCarloSimulations();
        this.initShim = null;
    }

    private ImmutableInfluenceMaximizationConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, List<String> relationshipTypes, List<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.seedSetSize = seedSetSize;
        this.initShim.propagationProbability(propagationProbability);
        this.initShim.monteCarloSimulations(monteCarloSimulations);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.propagationProbability = this.initShim.propagationProbability();
        this.monteCarloSimulations = this.initShim.monteCarloSimulations();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return InfluenceMaximizationConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return InfluenceMaximizationConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return InfluenceMaximizationConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return InfluenceMaximizationConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return InfluenceMaximizationConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return InfluenceMaximizationConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return InfluenceMaximizationConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return InfluenceMaximizationConfig.super.nodeLabels();
    }

    private double propagationProbabilityInitialize() {
        return InfluenceMaximizationConfig.super.propagationProbability();
    }

    private int monteCarloSimulationsInitialize() {
        return InfluenceMaximizationConfig.super.monteCarloSimulations();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Override
    public int seedSetSize() {
        return this.seedSetSize;
    }

    @Override
    public double propagationProbability() {
        InitShim shim = this.initShim;
        return shim != null ? shim.propagationProbability() : this.propagationProbability;
    }

    @Override
    public int monteCarloSimulations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.monteCarloSimulations() : this.monteCarloSimulations;
    }

    public final ImmutableInfluenceMaximizationConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withGraphName(@javax.annotation.Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(elements, true, false));
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(elements, true, false));
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withImplicitCreateConfig(@javax.annotation.Nullable GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.seedSetSize, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withSeedSetSize(int value) {
        if (this.seedSetSize == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.propagationProbability, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withPropagationProbability(double value) {
        if (Double.doubleToLongBits(this.propagationProbability) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, value, this.monteCarloSimulations));
    }

    public final ImmutableInfluenceMaximizationConfig withMonteCarloSimulations(int value) {
        if (this.monteCarloSimulations == value) {
            return this;
        }
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.seedSetSize, this.propagationProbability, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInfluenceMaximizationConfig && this.equalTo((ImmutableInfluenceMaximizationConfig)another);
    }

    private boolean equalTo(ImmutableInfluenceMaximizationConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && this.seedSetSize == another.seedSetSize && Double.doubleToLongBits(this.propagationProbability) == Double.doubleToLongBits(another.propagationProbability) && this.monteCarloSimulations == another.monteCarloSimulations;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + this.seedSetSize;
        h += (h << 5) + Double.hashCode(this.propagationProbability);
        h += (h << 5) + this.monteCarloSimulations;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InfluenceMaximizationConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 28) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        builder.append(", ");
        builder.append("seedSetSize=").append(this.seedSetSize);
        builder.append(", ");
        builder.append("propagationProbability=").append(this.propagationProbability);
        builder.append(", ");
        builder.append("monteCarloSimulations=").append(this.monteCarloSimulations);
        return builder.append("}").toString();
    }

    public static InfluenceMaximizationConfig of(int concurrency, int minBatchSize, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        return ImmutableInfluenceMaximizationConfig.of(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedSetSize, propagationProbability, monteCarloSimulations);
    }

    public static InfluenceMaximizationConfig of(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedSetSize, propagationProbability, monteCarloSimulations));
    }

    public static InfluenceMaximizationConfig of(int concurrency, int minBatchSize, @javax.annotation.Nullable String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @javax.annotation.Nullable GraphCreateConfig implicitCreateConfig, int seedSetSize, double propagationProbability, int monteCarloSimulations) {
        return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, seedSetSize, propagationProbability, monteCarloSimulations));
    }

    private static ImmutableInfluenceMaximizationConfig validate(ImmutableInfluenceMaximizationConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static InfluenceMaximizationConfig copyOf(InfluenceMaximizationConfig instance) {
        if (instance instanceof ImmutableInfluenceMaximizationConfig) {
            return (ImmutableInfluenceMaximizationConfig)instance;
        }
        return ImmutableInfluenceMaximizationConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="InfluenceMaximizationConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SEED_SET_SIZE = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_PROPAGATION_PROBABILITY = 64L;
        private static final long OPT_BIT_MONTE_CARLO_SIMULATIONS = 128L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String usernameOverride;
        private boolean sudo;
        @javax.annotation.Nullable
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        @javax.annotation.Nullable
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        @javax.annotation.Nullable
        private GraphCreateConfig implicitCreateConfig;
        private int seedSetSize;
        private double propagationProbability;
        private int monteCarloSimulations;

        private Builder() {
        }

        public final Builder from(InfluenceMaximizationConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InfluenceMaximizationConfig instance;
            if (object instanceof InfluenceMaximizationConfig) {
                instance = (InfluenceMaximizationConfig)object;
                this.seedSetSize(instance.seedSetSize());
                this.monteCarloSimulations(instance.monteCarloSimulations());
                this.propagationProbability(instance.propagationProbability());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphName(@javax.annotation.Nullable String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder implicitCreateConfig(@javax.annotation.Nullable GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder seedSetSize(int seedSetSize) {
            this.seedSetSize = seedSetSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder propagationProbability(double propagationProbability) {
            this.propagationProbability = propagationProbability;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder monteCarloSimulations(int monteCarloSimulations) {
            this.monteCarloSimulations = monteCarloSimulations;
            this.optBits |= 0x80L;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.seedSetSize = 0;
            this.propagationProbability = 0.0;
            this.monteCarloSimulations = 0;
            return this;
        }

        public InfluenceMaximizationConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableInfluenceMaximizationConfig.validate(new ImmutableInfluenceMaximizationConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean propagationProbabilityIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean monteCarloSimulationsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("seedSetSize");
            }
            return "Cannot build InfluenceMaximizationConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="InfluenceMaximizationConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte propagationProbabilityBuildStage = 0;
        private double propagationProbability;
        private byte monteCarloSimulationsBuildStage = 0;
        private int monteCarloSimulations;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableInfluenceMaximizationConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableInfluenceMaximizationConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableInfluenceMaximizationConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableInfluenceMaximizationConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableInfluenceMaximizationConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableInfluenceMaximizationConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(ImmutableInfluenceMaximizationConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableInfluenceMaximizationConfig.createUnmodifiableList(false, ImmutableInfluenceMaximizationConfig.createSafeList(ImmutableInfluenceMaximizationConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        double propagationProbability() {
            if (this.propagationProbabilityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propagationProbabilityBuildStage == 0) {
                this.propagationProbabilityBuildStage = (byte)-1;
                this.propagationProbability = ImmutableInfluenceMaximizationConfig.this.propagationProbabilityInitialize();
                this.propagationProbabilityBuildStage = 1;
            }
            return this.propagationProbability;
        }

        void propagationProbability(double propagationProbability) {
            this.propagationProbability = propagationProbability;
            this.propagationProbabilityBuildStage = 1;
        }

        int monteCarloSimulations() {
            if (this.monteCarloSimulationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.monteCarloSimulationsBuildStage == 0) {
                this.monteCarloSimulationsBuildStage = (byte)-1;
                this.monteCarloSimulations = ImmutableInfluenceMaximizationConfig.this.monteCarloSimulationsInitialize();
                this.monteCarloSimulationsBuildStage = 1;
            }
            return this.monteCarloSimulations;
        }

        void monteCarloSimulations(int monteCarloSimulations) {
            this.monteCarloSimulations = monteCarloSimulations;
            this.monteCarloSimulationsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.propagationProbabilityBuildStage == -1) {
                attributes.add("propagationProbability");
            }
            if (this.monteCarloSimulationsBuildStage == -1) {
                attributes.add("monteCarloSimulations");
            }
            return "Cannot build InfluenceMaximizationConfig, attribute initializers form cycle " + attributes;
        }
    }
}

