/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreValidation;
import org.neo4j.gds.MutatePropertyProc;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongNodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.ml.nodemodels.NodeClassificationModelInfo;
import org.neo4j.gds.ml.nodemodels.NodeClassificationMutateConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictMutateProc
extends MutatePropertyProc<NodeClassificationPredict, NodeClassificationResult, MutateResult, NodeClassificationMutateConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.mutate(result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, NodeClassificationMutateConfig config) {
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
        config.predictedProbabilityProperty().ifPresent(predictedProbabilityProperty -> {
            if (config.mutateProperty().equals(predictedProbabilityProperty)) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Configuration parameters `%s` and `%s` must be different (both were `%s`)", (Object[])new Object[]{"mutateProperty", "predictedProbabilityProperty", predictedProbabilityProperty}));
            }
        });
        NodeClassificationTrainConfig trainConfig = (NodeClassificationTrainConfig)this.modelCatalog.get(config.username(), config.modelName(), NodeLogisticRegressionData.class, NodeClassificationTrainConfig.class, NodeClassificationModelInfo.class).trainConfig();
        GraphStoreValidation.validate((GraphStore)graphStore, (AlgoBaseConfig)trainConfig);
    }

    protected NodeClassificationMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationMutateConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory(this.modelCatalog);
    }

    protected List<NodeProperty> nodePropertyList(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationMutateConfig> computationResult) {
        NodeClassificationMutateConfig config = (NodeClassificationMutateConfig)computationResult.config();
        String mutateProperty = config.mutateProperty();
        NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
        LongNodeProperties classProperties = result.predictedClasses().asNodeProperties();
        ArrayList<NodeProperty> nodeProperties = new ArrayList<NodeProperty>();
        nodeProperties.add(NodeProperty.of((String)mutateProperty, (NodeProperties)classProperties));
        result.predictedProbabilities().ifPresent(probabilityProperties -> {
            DoubleArrayNodeProperties properties = new DoubleArrayNodeProperties((AlgoBaseProc.ComputationResult)computationResult, (HugeObjectArray)probabilityProperties){
                final /* synthetic */ AlgoBaseProc.ComputationResult val$computationResult;
                final /* synthetic */ HugeObjectArray val$probabilityProperties;
                {
                    this.val$computationResult = computationResult;
                    this.val$probabilityProperties = hugeObjectArray;
                }

                public long size() {
                    return this.val$computationResult.graph().nodeCount();
                }

                public double[] doubleArrayValue(long nodeId) {
                    return (double[])this.val$probabilityProperties.get(nodeId);
                }
            };
            nodeProperties.add(NodeProperty.of((String)((String)config.predictedProbabilityProperty().orElseThrow()), (NodeProperties)properties));
        });
        return nodeProperties;
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long nodePropertiesWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long nodePropertiesWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.nodePropertiesWritten = nodePropertiesWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.nodePropertiesWritten, this.config.toMap());
            }
        }
    }
}

