/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.impl.triangle.TriangleStream;
import org.neo4j.gds.triangle.TriangleCountBaseConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleProc
extends AlgoBaseProc<TriangleStream, Stream<TriangleStream.Result>, TriangleCountBaseConfig> {
    private static final String DESCRIPTION = "Triangles streams the nodeIds of each triangle in the graph.";

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, TriangleCountBaseConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    @Procedure(name="gds.alpha.triangles", mode=Mode.READ)
    @Description(value="Triangles streams the nodeIds of each triangle in the graph.")
    public Stream<TriangleStream.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        Stream resultStream = (Stream)computationResult.result();
        try (Statement statement = this.transaction.acquireStatement();){
            statement.registerCloseableResource((AutoCloseable)resultStream);
        }
        return resultStream;
    }

    protected TriangleCountBaseConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TriangleCountBaseConfig.of(graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<TriangleStream, TriangleCountBaseConfig> algorithmFactory() {
        return new AlgorithmFactory<TriangleStream, TriangleCountBaseConfig>(){

            protected String taskName() {
                return "TriangleStream";
            }

            protected TriangleStream build(Graph graph, TriangleCountBaseConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return (TriangleStream)TriangleStream.create((Graph)graph, (ExecutorService)Pools.DEFAULT, (int)configuration.concurrency()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)TriangleProc.this.transaction));
            }
        };
    }
}

