/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.DoubleHistogram;

public class AlphaSimilaritySummaryResult {
    public final long nodes;
    public final long sourceNodes;
    public final long targetNodes;
    public final long similarityPairs;
    public final long computations;
    public final String writeRelationshipType;
    public final String writeProperty;
    public final double min;
    public final double max;
    public final double mean;
    public final double stdDev;
    public final double p25;
    public final double p50;
    public final double p75;
    public final double p90;
    public final double p95;
    public final double p99;
    public final double p999;
    public final double p100;

    public AlphaSimilaritySummaryResult(long nodes, long sourceNodes, long targetNodes, long similarityPairs, long computations, String writeRelationshipType, String writeProperty, double min, double max, double mean, double stdDev, double p25, double p50, double p75, double p90, double p95, double p99, double p999, double p100) {
        this.nodes = nodes;
        this.sourceNodes = sourceNodes;
        this.targetNodes = targetNodes;
        this.similarityPairs = similarityPairs;
        this.computations = computations;
        this.writeRelationshipType = writeRelationshipType;
        this.writeProperty = writeProperty;
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.stdDev = stdDev;
        this.p25 = p25;
        this.p50 = p50;
        this.p75 = p75;
        this.p90 = p90;
        this.p95 = p95;
        this.p99 = p99;
        this.p999 = p999;
        this.p100 = p100;
    }

    public static AlphaSimilaritySummaryResult from(long length, long sourceIdsLength, long targetIdsLength, AtomicLong similarityPairs, long computations, String writeRelationshipType, String writeProperty, DoubleHistogram histogram) {
        long sourceNodes = sourceIdsLength == 0L ? length : sourceIdsLength;
        long targetNodes = targetIdsLength == 0L ? length : targetIdsLength;
        return new AlphaSimilaritySummaryResult(length, sourceNodes, targetNodes, similarityPairs.get(), computations, writeRelationshipType, writeProperty, histogram.getMinValue(), histogram.getMaxValue(), histogram.getMean(), histogram.getStdDeviation(), histogram.getValueAtPercentile(25.0), histogram.getValueAtPercentile(50.0), histogram.getValueAtPercentile(75.0), histogram.getValueAtPercentile(90.0), histogram.getValueAtPercentile(95.0), histogram.getValueAtPercentile(99.0), histogram.getValueAtPercentile(99.9), histogram.getValueAtPercentile(100.0));
    }
}

