/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.pregel.SpeakerListenerLPA;
import org.neo4j.gds.pregel.SpeakerListenerLPAAlgorithm;
import org.neo4j.gds.pregel.proc.PregelStreamProc;
import org.neo4j.gds.pregel.proc.PregelStreamResult;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class SpeakerListenerLPAStreamProc
extends PregelStreamProc<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> {
    @Procedure(name="gds.alpha.sllpa.stream", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelStreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.sllpa.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> streamEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected PregelStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException();
    }

    protected SpeakerListenerLPA.SpeakerListenerLPAConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.of(graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> algorithmFactory() {
        return new AlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig>(){

            public SpeakerListenerLPAAlgorithm build(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                return new SpeakerListenerLPAAlgorithm(graph, configuration, allocationTracker, progressTracker);
            }

            protected String taskName() {
                return SpeakerListenerLPAAlgorithm.class.getSimpleName();
            }

            public Task progressTask(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                return Pregel.progressTask((Graph)graph, (PregelConfig)configuration);
            }

            public MemoryEstimation memoryEstimation(SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                SpeakerListenerLPA computation = new SpeakerListenerLPA();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(configuration), (boolean)computation.reducer().isPresent(), (boolean)configuration.isAsynchronous());
            }
        };
    }
}

