/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamResult;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineStreamConfig;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineStreamProc
extends StreamProc<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationStreamResult, NodeClassificationPredictPipelineStreamConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.predict.stream", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained pipeline model")
    public Stream<NodeClassificationStreamResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream((AlgoBaseProc.ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineStreamConfig>)this.compute(graphNameOrConfig, configuration));
    }

    protected Stream<NodeClassificationStreamResult> stream(AlgoBaseProc.ComputationResult<NodeClassificationPredictPipelineExecutor, NodeClassificationResult, NodeClassificationPredictPipelineStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph streaming failed", () -> {
            Graph graph = computationResult.graph();
            NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
            HugeLongArray predictedClasses = result.predictedClasses();
            Optional predictedProbabilities = result.predictedProbabilities();
            return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new NodeClassificationStreamResult(graph.toOriginalNodeId(nodeId.longValue()), predictedClasses.get(nodeId.longValue()), this.nodePropertiesAsList(predictedProbabilities, (long)nodeId)));
        });
    }

    private List<Double> nodePropertiesAsList(Optional<HugeObjectArray<double[]>> predictedProbabilities, long nodeId) {
        return predictedProbabilities.map(p -> {
            double[] values = (double[])p.get(nodeId);
            return Arrays.stream(values).boxed().collect(Collectors.toList());
        }).orElse(null);
    }

    protected NodeClassificationStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("NodeClassification handles result building individually.");
    }

    protected NodeClassificationPredictPipelineStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationPredictPipelineStreamConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<NodeClassificationPredictPipelineExecutor, NodeClassificationPredictPipelineStreamConfig> algorithmFactory() {
        return new NodeClassificationPredictPipelineAlgorithmFactory<NodeClassificationPredictPipelineStreamConfig>((BaseProc)this, this.databaseId(), this.modelCatalog);
    }
}

