/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.GraphStoreValidation;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.ml.nodemodels.NodeClassificationModelInfo;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamResult;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeClassificationResult;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictStreamProc
extends StreamProc<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamResult, NodeClassificationStreamConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.stream", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<NodeClassificationStreamResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.stream((AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig>)result);
    }

    @Procedure(name="gds.alpha.ml.nodeClassification.predict.stream.estimate", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected Stream<NodeClassificationStreamResult> stream(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph streaming failed", () -> {
            Graph graph = computationResult.graph();
            NodeClassificationResult result = (NodeClassificationResult)computationResult.result();
            HugeLongArray predictedClasses = result.predictedClasses();
            Optional predictedProbabilities = result.predictedProbabilities();
            return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new NodeClassificationStreamResult(graph.toOriginalNodeId(nodeId.longValue()), predictedClasses.get(nodeId.longValue()), this.nodePropertiesAsList(predictedProbabilities, (long)nodeId)));
        });
    }

    private List<Double> nodePropertiesAsList(Optional<HugeObjectArray<double[]>> predictedProbabilities, long nodeId) {
        return predictedProbabilities.map(p -> {
            double[] values = (double[])p.get(nodeId);
            return Arrays.stream(values).boxed().collect(Collectors.toList());
        }).orElse(null);
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, NodeClassificationStreamConfig config) {
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
        NodeClassificationTrainConfig trainConfig = (NodeClassificationTrainConfig)this.modelCatalog.get(config.username(), config.modelName(), NodeLogisticRegressionData.class, NodeClassificationTrainConfig.class, NodeClassificationModelInfo.class).trainConfig();
        GraphStoreValidation.validate((GraphStore)graphStore, (AlgoBaseConfig)trainConfig);
    }

    protected NodeClassificationStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationStreamConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory(this.modelCatalog);
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<NodeClassificationPredict, NodeClassificationResult, NodeClassificationStreamConfig> computationResult) {
        return super.nodeProperties(computationResult);
    }

    protected NodeClassificationStreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("NodeClassification handles result building individually.");
    }
}

