/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.train;

import java.util.List;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrain;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainPipelineExecutor;
import org.neo4j.kernel.database.NamedDatabaseId;

public class LinkPredictionTrainPipelineAlgorithmFactory
extends AlgorithmFactory<LinkPredictionTrainPipelineExecutor, LinkPredictionTrainConfig> {
    private final BaseProc caller;
    private final NamedDatabaseId databaseId;
    private final ModelCatalog modelCatalog;

    public LinkPredictionTrainPipelineAlgorithmFactory(BaseProc caller, NamedDatabaseId databaseId, ModelCatalog modelCatalog) {
        this.caller = caller;
        this.databaseId = databaseId;
        this.modelCatalog = modelCatalog;
    }

    public LinkPredictionTrainPipelineExecutor build(Graph graph, LinkPredictionTrainConfig trainConfig, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        String graphName = (String)trainConfig.graphName().orElseThrow(() -> new UnsupportedOperationException("Link Prediction Pipeline cannot be used with anonymous graphs. Please load the graph before"));
        GraphStore graphStore = GraphStoreCatalog.get((CatalogRequest)CatalogRequest.of((String)trainConfig.username(), (NamedDatabaseId)this.databaseId), (String)graphName).graphStore();
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog, trainConfig.pipeline(), trainConfig.username());
        pipeline.validate();
        return new LinkPredictionTrainPipelineExecutor(pipeline, trainConfig, this.caller, graphStore, graphName, progressTracker);
    }

    protected String taskName() {
        return "Link Prediction Train Pipeline";
    }

    public Task progressTask(Graph graph, LinkPredictionTrainConfig config) {
        LinkPredictionPipeline pipeline = LinkPredictionPipelineCompanion.getLPPipeline(this.modelCatalog, config.pipeline(), config.username());
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"split relationships"), (Task[])new Task[]{Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)pipeline.nodePropertySteps().size()), LinkPredictionTrain.progressTask()});
    }

    public MemoryEstimation memoryEstimation(LinkPredictionTrainConfig configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

