/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.utils.StringFormatting;

public final class LinkPredictionPipelineCompanion {
    public static final String PREDICT_DESCRIPTION = "Predicts relationships for all node pairs based on a previously trained link prediction model.";
    public static final String PIPELINE_MODEL_TYPE = "Link prediction training pipeline";
    static final List<Map<String, Object>> DEFAULT_PARAM_CONFIG = List.of(LinkLogisticRegressionTrainConfig.defaultConfig().toMap());

    private LinkPredictionPipelineCompanion() {
    }

    public static LinkPredictionPipeline getLPPipeline(ModelCatalog modelCatalog, String pipelineName, String username) {
        Model model = modelCatalog.getUntypedOrThrow(username, pipelineName);
        assert (model != null);
        if (!model.algoType().equals(PIPELINE_MODEL_TYPE)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Steps can only be added to a model of type `%s`. But model `%s` is of type `%s`.", (Object[])new Object[]{PIPELINE_MODEL_TYPE, pipelineName, model.algoType()}));
        }
        assert (model.customInfo() instanceof LinkPredictionPipeline);
        return (LinkPredictionPipeline)model.customInfo();
    }

    public static Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> getTrainedLPPipelineModel(ModelCatalog modelCatalog, String pipelineName, String username) {
        return modelCatalog.get(username, pipelineName, LinkLogisticRegressionData.class, LinkPredictionTrainConfig.class, LinkPredictionModelInfo.class);
    }
}

