/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.pipeline.Pipeline;

public class LinkPredictionPipeline
extends Pipeline<LinkFeatureStep, LinkLogisticRegressionTrainConfig> {
    private LinkPredictionSplitConfig splitConfig = LinkPredictionSplitConfig.DEFAULT_CONFIG;

    public LinkPredictionPipeline() {
        super(List.of(LinkLogisticRegressionTrainConfig.defaultConfig()));
    }

    public LinkPredictionPipeline copy() {
        LinkPredictionPipeline copied = new LinkPredictionPipeline();
        copied.featureSteps.addAll(this.featureSteps);
        copied.nodePropertySteps.addAll(this.nodePropertySteps);
        copied.setTrainingParameterSpace(new ArrayList(this.trainingParameterSpace));
        copied.setSplitConfig(this.splitConfig);
        return copied;
    }

    protected Map<String, List<Map<String, Object>>> featurePipelineDescription() {
        return Map.of("nodePropertySteps", ToMapConvertible.toMap((List)this.nodePropertySteps), "featureSteps", ToMapConvertible.toMap((List)this.featureSteps));
    }

    protected Map<String, Object> additionalEntries() {
        return Map.of("splitConfig", this.splitConfig.toMap());
    }

    public LinkPredictionSplitConfig splitConfig() {
        return this.splitConfig;
    }

    public void setSplitConfig(LinkPredictionSplitConfig splitConfig) {
        this.splitConfig = splitConfig;
    }

    public void validate() {
        if (this.featureSteps().isEmpty()) {
            throw new IllegalArgumentException("Training a Link prediction pipeline requires at least one feature. You can add features with the procedure `gds.alpha.ml.pipeline.linkPrediction.addFeature`.");
        }
    }

    public Map<String, List<String>> tasksByRelationshipProperty() {
        HashMap<String, List<String>> tasksByRelationshipProperty = new HashMap<String, List<String>>();
        this.nodePropertySteps().forEach(existingStep -> {
            if (existingStep.config().containsKey("relationshipWeightProperty")) {
                String existingProperty = (String)existingStep.config().get("relationshipWeightProperty");
                List tasks = tasksByRelationshipProperty.computeIfAbsent(existingProperty, key -> new ArrayList());
                tasks.add(existingStep.procName());
            }
        });
        return tasksByRelationshipProperty;
    }

    public Optional<String> relationshipWeightProperty() {
        Set<Map.Entry<String, List<String>>> relationshipWeightPropertySet = this.tasksByRelationshipProperty().entrySet();
        return relationshipWeightPropertySet.isEmpty() ? Optional.empty() : Optional.of(relationshipWeightPropertySet.iterator().next().getKey());
    }
}

