/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nil;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.CompositeRelationshipIterator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.NodeMapping;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.GraphSchema;
import org.neo4j.gds.core.loading.DeletionResult;
import org.neo4j.gds.similarity.nil.NullGraph;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.storable.NumberType;

public class NullGraphStore
implements GraphStore {
    private final NamedDatabaseId databaseId;

    public NullGraphStore(NamedDatabaseId databaseId) {
        this.databaseId = databaseId;
    }

    public NamedDatabaseId databaseId() {
        return this.databaseId;
    }

    public GraphSchema schema() {
        throw new NullGraphException();
    }

    public ZonedDateTime modificationTime() {
        return ZonedDateTime.now();
    }

    public long nodeCount() {
        return 0L;
    }

    public NodeMapping nodes() {
        throw new NullGraphException();
    }

    public Set<NodeLabel> nodeLabels() {
        return Set.of();
    }

    public Set<String> nodePropertyKeys(NodeLabel label) {
        return Set.of();
    }

    public Map<NodeLabel, Set<String>> nodePropertyKeys() {
        return Map.of();
    }

    public boolean hasNodeProperty(NodeLabel label, String propertyKey) {
        return false;
    }

    public boolean hasNodeProperty(Collection<NodeLabel> labels, String propertyKey) {
        return false;
    }

    public ValueType nodePropertyType(NodeLabel label, String propertyKey) {
        return ValueType.UNKNOWN;
    }

    public PropertyState nodePropertyState(String propertyKey) {
        return PropertyState.TRANSIENT;
    }

    public NodeProperties nodePropertyValues(String propertyKey) {
        throw new NullGraphException();
    }

    public NodeProperties nodePropertyValues(NodeLabel label, String propertyKey) {
        throw new NullGraphException();
    }

    public void addNodeProperty(NodeLabel nodeLabel, String propertyKey, NodeProperties propertyValues) {
    }

    public void removeNodeProperty(NodeLabel nodeLabel, String propertyKey) {
    }

    public long relationshipCount() {
        return 0L;
    }

    public long relationshipCount(RelationshipType relationshipType) {
        return 0L;
    }

    public Set<RelationshipType> relationshipTypes() {
        return Set.of();
    }

    public boolean hasRelationshipType(RelationshipType relationshipType) {
        return false;
    }

    public boolean hasRelationshipProperty(RelationshipType relType, String propertyKey) {
        return false;
    }

    public ValueType relationshipPropertyType(String propertyKey) {
        return ValueType.UNKNOWN;
    }

    public Set<String> relationshipPropertyKeys() {
        return Set.of();
    }

    public Set<String> relationshipPropertyKeys(RelationshipType relationshipType) {
        return Set.of();
    }

    public RelationshipProperty relationshipPropertyValues(RelationshipType relationshipType, String propertyKey) {
        return RelationshipPropertyStore.empty().get(propertyKey);
    }

    public void addRelationshipType(RelationshipType relationshipType, Optional<String> relationshipPropertyKey, Optional<NumberType> relationshipPropertyType, Relationships relationships) {
    }

    public DeletionResult deleteRelationships(RelationshipType relationshipType) {
        return DeletionResult.of(c -> {});
    }

    public Graph getGraph(Collection<NodeLabel> nodeLabels, Collection<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty) {
        return new NullGraph();
    }

    public Graph getUnion() {
        return new NullGraph();
    }

    public CompositeRelationshipIterator getCompositeRelationshipIterator(RelationshipType relationshipType, List<String> propertyKeys) {
        throw new NullGraphException();
    }

    public void canRelease(boolean canRelease) {
    }

    public void release() {
    }

    static class NullGraphException
    extends UnsupportedOperationException {
        NullGraphException() {
            super("This algorithm does not support operating on named graphs. Please report this stacktrace to https://github.com/neo4j/graph-data-science");
        }
    }
}

