/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.impl.similarity.EuclideanAlgorithm;
import org.neo4j.gds.impl.similarity.EuclideanConfig;
import org.neo4j.gds.impl.similarity.EuclideanConfigImpl;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.AlphaSimilarityProc;
import org.neo4j.gds.similarity.AlphaSimilarityStatsResult;
import org.neo4j.gds.similarity.AlphaSimilaritySummaryResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class EuclideanProc
extends AlphaSimilarityProc<EuclideanAlgorithm, EuclideanConfig> {
    private static final String DESCRIPTION = "Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.";

    @Procedure(name="gds.alpha.similarity.euclidean.stream", mode=Mode.READ)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<SimilarityResult> euclideanStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.euclidean.write", mode=Mode.WRITE)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<AlphaSimilaritySummaryResult> euclideanWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.euclidean.stats", mode=Mode.READ)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<AlphaSimilarityStatsResult> euclideanStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected EuclideanConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new EuclideanConfigImpl(graphName, maybeImplicitCreate, userInput);
    }

    @Override
    EuclideanAlgorithm newAlgo(EuclideanConfig config, AllocationTracker allocationTracker) {
        return new EuclideanAlgorithm(config, this.api);
    }

    @Override
    String taskName() {
        return "Euclidean-similarity";
    }
}

