/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.shortestpath;

import java.util.Optional;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.shortestpath.ShortestPathDeltaSteppingConfigImpl;
import org.neo4j.graphdb.Node;

@ValueClass
@Configuration
public interface ShortestPathDeltaSteppingConfig
extends AlgoBaseConfig,
RelationshipWeightConfig,
WritePropertyConfig {
    public static final String DEFAULT_TARGET_PROPERTY = "sssp";

    @Configuration.ConvertWith(value="nodeId")
    public long startNode();

    public double delta();

    default public String writeProperty() {
        return DEFAULT_TARGET_PROPERTY;
    }

    public static long nodeId(Node node) {
        return node.getId();
    }

    public static ShortestPathDeltaSteppingConfig of(Optional<String> graphName, Optional<GraphCreateConfig> implicitCreateConfig, CypherMapWrapper config) {
        return new ShortestPathDeltaSteppingConfigImpl(graphName, implicitCreateConfig, config);
    }
}

