/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.splitting;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.ml.splitting.EdgeSplitter;
import org.neo4j.gds.ml.splitting.SplitRelationships;
import org.neo4j.gds.ml.splitting.SplitRelationshipsMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

public class SplitRelationshipsMutateProc
extends MutateProc<SplitRelationships, EdgeSplitter.SplitResult, MutateResult, SplitRelationshipsMutateConfig> {
    @Procedure(name="gds.alpha.ml.splitRelationships.mutate", mode=Mode.READ)
    @Description(value="Splits a graph into holdout and remaining relationship types and adds them to the in-memory graph.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return this.mutate(computationResult);
    }

    protected SplitRelationshipsMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SplitRelationshipsMutateConfig.of(graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<SplitRelationships, SplitRelationshipsMutateConfig> algorithmFactory() {
        return new AlgorithmFactory<SplitRelationships, SplitRelationshipsMutateConfig>(){

            protected String taskName() {
                return "SplitRelationships";
            }

            protected SplitRelationships build(Graph graph, SplitRelationshipsMutateConfig configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
                Graph masterGraph = graph;
                if (!configuration.nonNegativeRelationshipTypes().isEmpty()) {
                    GraphStore graphStore = SplitRelationshipsMutateProc.this.graphStoreFromCatalog((String)configuration.graphName().get(), (BaseConfig)configuration).graphStore();
                    masterGraph = graphStore.getGraph(configuration.nodeLabelIdentifiers(graphStore), (Collection)configuration.superGraphTypes(), Optional.empty());
                }
                return new SplitRelationships(graph, masterGraph, configuration);
            }
        };
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<SplitRelationships, EdgeSplitter.SplitResult, SplitRelationshipsMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<SplitRelationships, EdgeSplitter.SplitResult, SplitRelationshipsMutateConfig> computationResult) {
        SplitRelationshipsMutateConfig config = (SplitRelationshipsMutateConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(config.remainingRelationshipType(), Optional.ofNullable(config.relationshipWeightProperty()), Optional.of(NumberType.FLOATING_POINT), ((EdgeSplitter.SplitResult)computationResult.result()).remainingRels());
            computationResult.graphStore().addRelationshipType(config.holdoutRelationshipType(), Optional.of("label"), Optional.of(NumberType.INTEGRAL), ((EdgeSplitter.SplitResult)computationResult.result()).selectedRels());
        }
        long holdoutWritten = ((EdgeSplitter.SplitResult)computationResult.result()).selectedRels().topology().elementCount();
        long remainingWritten = ((EdgeSplitter.SplitResult)computationResult.result()).remainingRels().topology().elementCount();
        resultBuilder.withRelationshipsWritten(holdoutWritten + remainingWritten);
    }

    protected void validateConfigsAfterLoad(GraphStore graphStore, GraphCreateConfig graphCreateConfig, SplitRelationshipsMutateConfig config) {
        this.validateTypeDoesNotExist(graphStore, config.holdoutRelationshipType());
        this.validateTypeDoesNotExist(graphStore, config.remainingRelationshipType());
        this.validateNonNegativeRelationshipTypesExist(graphStore, config);
        super.validateConfigsAfterLoad(graphStore, graphCreateConfig, (AlgoBaseConfig)config);
    }

    private void validateNonNegativeRelationshipTypesExist(GraphStore graphStore, SplitRelationshipsMutateConfig config) {
        config.nonNegativeRelationshipTypes().forEach(relationshipType -> {
            if (!graphStore.hasRelationshipType(RelationshipType.of((String)relationshipType))) {
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship type `%s` does not exist in the in-memory graph.", (Object[])new Object[]{relationshipType}));
            }
        });
    }

    private void validateTypeDoesNotExist(GraphStore graphStore, RelationshipType holdoutRelationshipType) {
        if (graphStore.hasRelationshipType(holdoutRelationshipType)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Relationship type `%s` already exists in the in-memory graph.", (Object[])new Object[]{holdoutRelationshipType.name()}));
        }
    }

    public static class MutateResult {
        public final long createMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long relationshipsWritten;
        public final Map<String, Object> configuration;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.relationshipsWritten = relationshipsWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

