/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictConfigImpl;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionData;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipeline;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineCompanion;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineModelInfo;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineTrainConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineExecutor;
import org.neo4j.kernel.database.NamedDatabaseId;

public class NodeClassificationPredictPipelineAlgorithmFactory<CONFIG extends NodeClassificationPredictPipelineBaseConfig>
extends AlgorithmFactory<NodeClassificationPredictPipelineExecutor, CONFIG> {
    private final BaseProc caller;
    private final NamedDatabaseId databaseId;
    private final NodeClassificationPredictAlgorithmFactory<NodeClassificationPredictConfig> innerFactory;
    private final ModelCatalog modelCatalog;

    NodeClassificationPredictPipelineAlgorithmFactory(BaseProc caller, NamedDatabaseId databaseId, ModelCatalog modelCatalog) {
        this.caller = caller;
        this.databaseId = databaseId;
        this.innerFactory = new NodeClassificationPredictAlgorithmFactory(modelCatalog);
        this.modelCatalog = modelCatalog;
    }

    protected Task progressTask(Graph graph, CONFIG config) {
        NodeClassificationPipeline trainingPipeline = ((NodeClassificationPipelineModelInfo)NodeClassificationPipelineCompanion.getTrainedNCPipelineModel(this.modelCatalog, config.modelName(), config.username()).customInfo()).trainingPipeline();
        return Tasks.task((String)this.taskName(), (Task)Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)trainingPipeline.nodePropertySteps().size()), (Task[])new Task[]{this.innerFactory.progressTask(graph, this.innerConfig(config))});
    }

    private NodeClassificationPredictConfig innerConfig(CONFIG configuration) {
        return new NodeClassificationPredictConfigImpl(configuration.graphName(), configuration.implicitCreateConfig(), configuration.username(), CypherMapWrapper.create((Map)configuration.toMap()).withEntry("includePredictedProbabilities", (Object)configuration.includePredictedProbabilities()).withoutEntry("predictedProbabilityProperty"));
    }

    protected String taskName() {
        return "Node Classification Predict Pipeline";
    }

    protected NodeClassificationPredictPipelineExecutor build(Graph graph, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        String graphName = (String)configuration.graphName().orElseThrow(() -> new UnsupportedOperationException("Node Classification Pipeline cannot be used with anonymous graphs. Please load the graph before"));
        Model<NodeLogisticRegressionData, NodeClassificationPipelineTrainConfig, NodeClassificationPipelineModelInfo> model = NodeClassificationPipelineCompanion.getTrainedNCPipelineModel(this.modelCatalog, configuration.modelName(), configuration.username());
        GraphStore graphStore = GraphStoreCatalog.get((CatalogRequest)CatalogRequest.of((String)configuration.username(), (NamedDatabaseId)this.databaseId), (String)graphName).graphStore();
        NodeClassificationPipeline nodeClassificationPipeline = ((NodeClassificationPipelineModelInfo)model.customInfo()).trainingPipeline();
        return new NodeClassificationPredictPipelineExecutor(nodeClassificationPipeline, (NodeClassificationPredictPipelineBaseConfig)configuration, this.caller, graphStore, graphName, progressTracker, (NodeLogisticRegressionData)model.data());
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

