/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline.predict;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.predict.NodeClassificationPredictPipelineBaseConfig;
import org.neo4j.gds.model.ModelConfig;

@Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
public final class ImmutableNodeClassificationPredictPipelineBaseConfig
implements NodeClassificationPredictPipelineBaseConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    private final String modelName;
    private final String username;
    private final boolean includePredictedProbabilities;
    private final int batchSize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNodeClassificationPredictPipelineBaseConfig(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.includePredictedProbabilities = includePredictedProbabilities;
        this.initShim.batchSize(batchSize);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableNodeClassificationPredictPipelineBaseConfig(int concurrency, int minBatchSize, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.includePredictedProbabilities = includePredictedProbabilities;
        this.initShim.batchSize(batchSize);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableNodeClassificationPredictPipelineBaseConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.modelName = builder.modelName;
        this.includePredictedProbabilities = builder.includePredictedProbabilities;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    private ImmutableNodeClassificationPredictPipelineBaseConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, int concurrency, int minBatchSize, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.modelName = modelName;
        this.initShim.username(username);
        this.includePredictedProbabilities = includePredictedProbabilities;
        this.initShim.batchSize(batchSize);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.username = this.initShim.username();
        this.batchSize = this.initShim.batchSize();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.minBatchSize();
    }

    private List<String> relationshipTypesInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.nodeLabels();
    }

    private String usernameInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.username();
    }

    private int batchSizeInitialize() {
        return NodeClassificationPredictPipelineBaseConfig.super.batchSize();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public boolean includePredictedProbabilities() {
        return this.includePredictedProbabilities;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(value, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, value, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, newValue, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, value, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(elements, true, false));
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(elements, true, false));
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.modelName, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, newValue, this.username, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, newValue, this.includePredictedProbabilities, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withIncludePredictedProbabilities(boolean value) {
        if (this.includePredictedProbabilities == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, value, this.batchSize));
    }

    public final ImmutableNodeClassificationPredictPipelineBaseConfig withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this.usernameOverride, this.sudo, this.configKeys, this.concurrency, this.minBatchSize, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.modelName, this.username, this.includePredictedProbabilities, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeClassificationPredictPipelineBaseConfig && this.equalTo((ImmutableNodeClassificationPredictPipelineBaseConfig)another);
    }

    private boolean equalTo(ImmutableNodeClassificationPredictPipelineBaseConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && this.modelName.equals(another.modelName) && this.username.equals(another.username) && this.includePredictedProbabilities == another.includePredictedProbabilities && this.batchSize == another.batchSize;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Boolean.hashCode(this.includePredictedProbabilities);
        h += (h << 5) + this.batchSize;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NodeClassificationPredictPipelineBaseConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 44) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        builder.append(", ");
        builder.append("modelName=").append(this.modelName);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("includePredictedProbabilities=").append(this.includePredictedProbabilities);
        builder.append(", ");
        builder.append("batchSize=").append(this.batchSize);
        return builder.append("}").toString();
    }

    public static NodeClassificationPredictPipelineBaseConfig of(int concurrency, int minBatchSize, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.of(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, modelName, username, includePredictedProbabilities, batchSize);
    }

    public static NodeClassificationPredictPipelineBaseConfig of(int concurrency, int minBatchSize, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, modelName, username, includePredictedProbabilities, batchSize));
    }

    public static NodeClassificationPredictPipelineBaseConfig of(int concurrency, int minBatchSize, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, String modelName, String username, boolean includePredictedProbabilities, int batchSize) {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(concurrency, minBatchSize, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, modelName, username, includePredictedProbabilities, batchSize));
    }

    private static ImmutableNodeClassificationPredictPipelineBaseConfig validate(ImmutableNodeClassificationPredictPipelineBaseConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static NodeClassificationPredictPipelineBaseConfig copyOf(NodeClassificationPredictPipelineBaseConfig instance) {
        if (instance instanceof ImmutableNodeClassificationPredictPipelineBaseConfig) {
            return (ImmutableNodeClassificationPredictPipelineBaseConfig)instance;
        }
        return ImmutableNodeClassificationPredictPipelineBaseConfig.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long INIT_BIT_INCLUDE_PREDICTED_PROBABILITIES = 2L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_BATCH_SIZE = 64L;
        private long initBits = 3L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private String modelName;
        private String username;
        private boolean includePredictedProbabilities;
        private int batchSize;

        private Builder() {
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeClassificationPredictPipelineBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ModelConfig instance;
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
                this.username(instance.username());
            }
            if (object instanceof NodeClassificationPredictPipelineBaseConfig) {
                instance = (NodeClassificationPredictPipelineBaseConfig)object;
                this.batchSize(instance.batchSize());
                this.includePredictedProbabilities(instance.includePredictedProbabilities());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder includePredictedProbabilities(boolean includePredictedProbabilities) {
            this.includePredictedProbabilities = includePredictedProbabilities;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 0x40L;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.modelName = null;
            this.username = null;
            this.includePredictedProbabilities = false;
            this.batchSize = 0;
            return this;
        }

        public NodeClassificationPredictPipelineBaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableNodeClassificationPredictPipelineBaseConfig.validate(new ImmutableNodeClassificationPredictPipelineBaseConfig(this));
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("includePredictedProbabilities");
            }
            return "Cannot build NodeClassificationPredictPipelineBaseConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NodeClassificationPredictPipelineBaseConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte usernameBuildStage = 0;
        private String username;
        private byte batchSizeBuildStage = 0;
        private int batchSize;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableNodeClassificationPredictPipelineBaseConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableNodeClassificationPredictPipelineBaseConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableNodeClassificationPredictPipelineBaseConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableNodeClassificationPredictPipelineBaseConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(ImmutableNodeClassificationPredictPipelineBaseConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableNodeClassificationPredictPipelineBaseConfig.createUnmodifiableList(false, ImmutableNodeClassificationPredictPipelineBaseConfig.createSafeList(ImmutableNodeClassificationPredictPipelineBaseConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableNodeClassificationPredictPipelineBaseConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableNodeClassificationPredictPipelineBaseConfig.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            return "Cannot build NodeClassificationPredictPipelineBaseConfig, attribute initializers form cycle " + attributes;
        }
    }
}

