/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.conductance;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.conductance.ConductanceProc;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.impl.conductance.Conductance;
import org.neo4j.gds.impl.conductance.ConductanceStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ConductanceStreamProc
extends StreamProc<Conductance, Conductance.Result, StreamResult, ConductanceStreamConfig> {
    @Procedure(value="gds.alpha.conductance.stream", mode=Mode.READ)
    @Description(value="Evaluates a division of nodes into communities based on the proportion of relationships that cross community boundaries.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        if (result.isGraphEmpty()) {
            result.graph().release();
            return Stream.empty();
        }
        return ((Conductance.Result)result.result()).streamCommunityResults().map(communityResult -> new StreamResult(communityResult.community(), communityResult.conductance()));
    }

    protected ConductanceStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ConductanceStreamConfig.of(graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<Conductance, ConductanceStreamConfig> algorithmFactory() {
        return ConductanceProc.algorithmFactory();
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("Conductance handles result building individually.");
    }

    public static class StreamResult {
        public final long community;
        public final double conductance;

        public StreamResult(long community, double conductance) {
            this.community = community;
            this.conductance = conductance;
        }
    }
}

