/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.walking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.paths.PathFactory;
import org.neo4j.gds.traversal.RandomWalk;
import org.neo4j.gds.traversal.RandomWalkAlgorithmFactory;
import org.neo4j.gds.traversal.RandomWalkStreamConfig;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class RandomWalkStreamProc
extends AlgoBaseProc<RandomWalk, Stream<long[]>, RandomWalkStreamConfig> {
    private static final String DESCRIPTION = "Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.";

    @Procedure(name="gds.alpha.randomWalk.stream", mode=Mode.READ)
    @Description(value="Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.")
    public Stream<RandomWalkResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        if (computationResult.graph().isEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        boolean returnPath = this.callContext.outputFields().anyMatch(field -> StringFormatting.toLowerCaseWithLocale((String)field).equals("path"));
        Function<List, Path> pathCreator = returnPath ? nodes -> PathFactory.create((Transaction)this.procedureTransaction, (List)nodes, (RelationshipType)RelationshipType.withName((String)"NEXT")) : nodes -> null;
        return ((Stream)computationResult.result()).map(nodes -> {
            List<Long> translatedNodes = this.translateInternalToNeoIds((long[])nodes, (IdMapping)computationResult.graph());
            Path path = (Path)pathCreator.apply(translatedNodes);
            return new RandomWalkResult(translatedNodes, path);
        });
    }

    protected RandomWalkStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return RandomWalkStreamConfig.of(graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<RandomWalk, RandomWalkStreamConfig> algorithmFactory() {
        return new RandomWalkAlgorithmFactory();
    }

    private List<Long> translateInternalToNeoIds(long[] nodes, IdMapping nodeMapping) {
        ArrayList<Long> translatedNodes = new ArrayList<Long>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            translatedNodes.add(i, nodeMapping.toOriginalNodeId(nodes[i]));
        }
        return translatedNodes;
    }

    public static final class RandomWalkResult {
        public List<Long> nodeIds;
        public Path path;

        RandomWalkResult(List<Long> nodeIds, Path path) {
            this.nodeIds = nodeIds;
            this.path = path;
        }
    }
}

