/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationPipelineAddSteps;
import org.neo4j.gds.ml.nodemodels.pipeline.PipelineInfoResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineAddStepProcs
extends BaseProc {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.addNodeProperty", mode=Mode.READ)
    @Description(value="Add a node property step to an existing node classification pipeline.")
    public Stream<PipelineInfoResult> addNodeProperty(@Name(value="pipelineName") String pipelineName, @Name(value="procedureName") String taskName, @Name(value="procedureConfiguration") Map<String, Object> procedureConfig) {
        return Stream.of(NodeClassificationPipelineAddSteps.addNodeProperty(this.modelCatalog, this.username(), this, pipelineName, taskName, procedureConfig));
    }

    @Procedure(name="gds.alpha.ml.pipeline.nodeClassification.addFeatures", mode=Mode.READ)
    @Description(value="Add one or several features to an existing node classification pipeline.")
    public Stream<PipelineInfoResult> addFeatures(@Name(value="pipelineName") String pipelineName, @Name(value="nodeProperties") Object nodeProperties) {
        return Stream.of(NodeClassificationPipelineAddSteps.addFeatures(this.modelCatalog, this.username(), pipelineName, nodeProperties));
    }
}

