/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.ml.nodemodels.logisticregression.NodeLogisticRegressionTrainCoreConfig;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationFeatureStep;
import org.neo4j.gds.ml.nodemodels.pipeline.NodeClassificationSplitConfig;
import org.neo4j.gds.ml.pipeline.Pipeline;

public class NodeClassificationPipeline
extends Pipeline<NodeClassificationFeatureStep, NodeLogisticRegressionTrainCoreConfig> {
    private NodeClassificationSplitConfig splitConfig = NodeClassificationSplitConfig.DEFAULT_CONFIG;

    public NodeClassificationPipeline() {
        super(List.of(NodeLogisticRegressionTrainCoreConfig.defaultConfig()));
    }

    public NodeClassificationPipeline copy() {
        NodeClassificationPipeline copied = new NodeClassificationPipeline();
        copied.featureSteps.addAll(this.featureSteps);
        copied.nodePropertySteps.addAll(this.nodePropertySteps);
        copied.setTrainingParameterSpace(new ArrayList(this.trainingParameterSpace));
        copied.setSplitConfig(this.splitConfig);
        return copied;
    }

    protected Map<String, Object> additionalEntries() {
        return Map.of("splitConfig", this.splitConfig.toMap());
    }

    public void setSplitConfig(NodeClassificationSplitConfig splitConfig) {
        this.splitConfig = splitConfig;
    }

    public NodeClassificationSplitConfig splitConfig() {
        return this.splitConfig;
    }

    public List<String> featureProperties() {
        return this.featureSteps().stream().flatMap(step -> step.inputNodeProperties().stream()).collect(Collectors.toList());
    }
}

