/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline.predict;

import java.util.List;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipelineCompanion;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineBaseConfig;
import org.neo4j.gds.ml.linkmodels.pipeline.predict.LinkPredictionPredictPipelineExecutor;
import org.neo4j.gds.ml.linkmodels.pipeline.train.LinkPredictionTrainConfig;
import org.neo4j.gds.similarity.knn.KnnBaseConfig;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.kernel.database.NamedDatabaseId;

public class LinkPredictionPredictPipelineAlgorithmFactory<CONFIG extends LinkPredictionPredictPipelineBaseConfig>
extends AlgorithmFactory<LinkPredictionPredictPipelineExecutor, CONFIG> {
    private final BaseProc caller;
    private final NamedDatabaseId databaseId;
    private final ModelCatalog modelCatalog;

    LinkPredictionPredictPipelineAlgorithmFactory(BaseProc caller, NamedDatabaseId databaseId, ModelCatalog modelCatalog) {
        this.caller = caller;
        this.databaseId = databaseId;
        this.modelCatalog = modelCatalog;
    }

    protected Task progressTask(Graph graph, CONFIG config) {
        LinkPredictionPipeline trainingPipeline = ((LinkPredictionModelInfo)LinkPredictionPipelineCompanion.getTrainedLPPipelineModel(this.modelCatalog, config.modelName(), config.username()).customInfo()).trainingPipeline();
        return Tasks.task((String)this.taskName(), (Task)Tasks.iterativeFixed((String)"execute node property steps", () -> List.of(Tasks.leaf((String)"step")), (int)trainingPipeline.nodePropertySteps().size()), (Task[])new Task[]{config.isApproximateStrategy() ? Tasks.task((String)"approximate link prediction", (Task)KnnFactory.knnTaskTree((Graph)graph, (KnnBaseConfig)config.approximateConfig()), (Task[])new Task[0]) : Tasks.leaf((String)"exhaustive link prediction", (long)graph.nodeCount()), Tasks.leaf((String)"clean up graph store")});
    }

    protected String taskName() {
        return "Link Prediction Predict Pipeline";
    }

    protected LinkPredictionPredictPipelineExecutor build(Graph graph, CONFIG configuration, AllocationTracker allocationTracker, ProgressTracker progressTracker) {
        String graphName = (String)configuration.graphName().orElseThrow(() -> new UnsupportedOperationException("Link Prediction Pipeline cannot be used with anonymous graphs. Please load the graph before"));
        Model<LinkLogisticRegressionData, LinkPredictionTrainConfig, LinkPredictionModelInfo> model = LinkPredictionPipelineCompanion.getTrainedLPPipelineModel(this.modelCatalog, configuration.modelName(), configuration.username());
        GraphStore graphStore = GraphStoreCatalog.get((CatalogRequest)CatalogRequest.of((String)configuration.username(), (NamedDatabaseId)this.databaseId), (String)graphName).graphStore();
        LinkPredictionPipeline linkPredictionPipeline = ((LinkPredictionModelInfo)model.customInfo()).trainingPipeline();
        return new LinkPredictionPredictPipelineExecutor(linkPredictionPipeline, (LinkLogisticRegressionData)model.data(), (LinkPredictionPredictPipelineBaseConfig)configuration, this.caller, graphStore, graphName, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

