/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionPipeline;
import org.neo4j.gds.ml.linkmodels.pipeline.linkFeatures.LinkFeatureStep;
import org.neo4j.gds.ml.linkmodels.pipeline.logisticRegression.LinkLogisticRegressionTrainConfig;
import org.neo4j.gds.ml.pipeline.NodePropertyStep;

public class PipelineInfoResult {
    public final String name;
    public final List<Map<String, Object>> nodePropertySteps;
    public final List<Map<String, Object>> featureSteps;
    public final Map<String, Object> splitConfig;
    public final Object parameterSpace;

    PipelineInfoResult(String pipelineName, LinkPredictionPipeline info) {
        this.name = pipelineName;
        this.nodePropertySteps = info.nodePropertySteps().stream().map(NodePropertyStep::toMap).collect(Collectors.toList());
        this.featureSteps = info.featureSteps().stream().map(LinkFeatureStep::toMap).collect(Collectors.toList());
        this.splitConfig = info.splitConfig().toMap();
        this.parameterSpace = info.trainingParameterSpace().stream().map(LinkLogisticRegressionTrainConfig::toMap).collect(Collectors.toList());
    }
}

