/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.config.ToMapConvertible;
import org.neo4j.gds.ml.linkmodels.pipeline.LinkPredictionSplitConfig;
import org.neo4j.gds.ml.splitting.SplitRelationshipsBaseConfig;

@Generated(from="LinkPredictionSplitConfig", generator="Immutables")
public final class ImmutableLinkPredictionSplitConfig
implements LinkPredictionSplitConfig {
    private final int validationFolds;
    private final double testFraction;
    private final double trainFraction;
    private final double negativeSamplingRatio;
    private final String testRelationshipType;
    private final String testComplementRelationshipType;
    private final String trainRelationshipType;
    private final String featureInputRelationshipType;
    private final Map<String, Object> toMap;
    private final transient SplitRelationshipsBaseConfig testSplit;
    private final transient SplitRelationshipsBaseConfig trainSplit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLinkPredictionSplitConfig(int validationFolds, double testFraction, double trainFraction, double negativeSamplingRatio, String testRelationshipType, String testComplementRelationshipType, String trainRelationshipType, String featureInputRelationshipType, Map<String, ? extends Object> toMap) {
        this.initShim.validationFolds(validationFolds);
        this.initShim.testFraction(testFraction);
        this.initShim.trainFraction(trainFraction);
        this.initShim.negativeSamplingRatio(negativeSamplingRatio);
        this.initShim.testRelationshipType(Objects.requireNonNull(testRelationshipType, "testRelationshipType"));
        this.initShim.testComplementRelationshipType(Objects.requireNonNull(testComplementRelationshipType, "testComplementRelationshipType"));
        this.initShim.trainRelationshipType(Objects.requireNonNull(trainRelationshipType, "trainRelationshipType"));
        this.initShim.featureInputRelationshipType(Objects.requireNonNull(featureInputRelationshipType, "featureInputRelationshipType"));
        this.toMap = ImmutableLinkPredictionSplitConfig.createUnmodifiableMap(true, false, toMap);
        this.validationFolds = this.initShim.validationFolds();
        this.testFraction = this.initShim.testFraction();
        this.trainFraction = this.initShim.trainFraction();
        this.negativeSamplingRatio = this.initShim.negativeSamplingRatio();
        this.testRelationshipType = this.initShim.testRelationshipType();
        this.testComplementRelationshipType = this.initShim.testComplementRelationshipType();
        this.trainRelationshipType = this.initShim.trainRelationshipType();
        this.featureInputRelationshipType = this.initShim.featureInputRelationshipType();
        this.testSplit = this.initShim.testSplit();
        this.trainSplit = this.initShim.trainSplit();
        this.initShim = null;
    }

    private ImmutableLinkPredictionSplitConfig(Builder builder) {
        Map<Object, Object> map = this.toMap = builder.toMap == null ? Collections.emptyMap() : ImmutableLinkPredictionSplitConfig.createUnmodifiableMap(false, false, builder.toMap);
        if (builder.validationFoldsIsSet()) {
            this.initShim.validationFolds(builder.validationFolds);
        }
        if (builder.testFractionIsSet()) {
            this.initShim.testFraction(builder.testFraction);
        }
        if (builder.trainFractionIsSet()) {
            this.initShim.trainFraction(builder.trainFraction);
        }
        if (builder.negativeSamplingRatioIsSet()) {
            this.initShim.negativeSamplingRatio(builder.negativeSamplingRatio);
        }
        if (builder.testRelationshipType != null) {
            this.initShim.testRelationshipType(builder.testRelationshipType);
        }
        if (builder.testComplementRelationshipType != null) {
            this.initShim.testComplementRelationshipType(builder.testComplementRelationshipType);
        }
        if (builder.trainRelationshipType != null) {
            this.initShim.trainRelationshipType(builder.trainRelationshipType);
        }
        if (builder.featureInputRelationshipType != null) {
            this.initShim.featureInputRelationshipType(builder.featureInputRelationshipType);
        }
        this.validationFolds = this.initShim.validationFolds();
        this.testFraction = this.initShim.testFraction();
        this.trainFraction = this.initShim.trainFraction();
        this.negativeSamplingRatio = this.initShim.negativeSamplingRatio();
        this.testRelationshipType = this.initShim.testRelationshipType();
        this.testComplementRelationshipType = this.initShim.testComplementRelationshipType();
        this.trainRelationshipType = this.initShim.trainRelationshipType();
        this.featureInputRelationshipType = this.initShim.featureInputRelationshipType();
        this.testSplit = this.initShim.testSplit();
        this.trainSplit = this.initShim.trainSplit();
        this.initShim = null;
    }

    private ImmutableLinkPredictionSplitConfig(ImmutableLinkPredictionSplitConfig original, int validationFolds, double testFraction, double trainFraction, double negativeSamplingRatio, String testRelationshipType, String testComplementRelationshipType, String trainRelationshipType, String featureInputRelationshipType, Map<String, Object> toMap) {
        this.initShim.validationFolds(validationFolds);
        this.initShim.testFraction(testFraction);
        this.initShim.trainFraction(trainFraction);
        this.initShim.negativeSamplingRatio(negativeSamplingRatio);
        this.initShim.testRelationshipType(testRelationshipType);
        this.initShim.testComplementRelationshipType(testComplementRelationshipType);
        this.initShim.trainRelationshipType(trainRelationshipType);
        this.initShim.featureInputRelationshipType(featureInputRelationshipType);
        this.toMap = toMap;
        this.validationFolds = this.initShim.validationFolds();
        this.testFraction = this.initShim.testFraction();
        this.trainFraction = this.initShim.trainFraction();
        this.negativeSamplingRatio = this.initShim.negativeSamplingRatio();
        this.testRelationshipType = this.initShim.testRelationshipType();
        this.testComplementRelationshipType = this.initShim.testComplementRelationshipType();
        this.trainRelationshipType = this.initShim.trainRelationshipType();
        this.featureInputRelationshipType = this.initShim.featureInputRelationshipType();
        this.testSplit = this.initShim.testSplit();
        this.trainSplit = this.initShim.trainSplit();
        this.initShim = null;
    }

    private int validationFoldsInitialize() {
        return LinkPredictionSplitConfig.super.validationFolds();
    }

    private double testFractionInitialize() {
        return LinkPredictionSplitConfig.super.testFraction();
    }

    private double trainFractionInitialize() {
        return LinkPredictionSplitConfig.super.trainFraction();
    }

    private double negativeSamplingRatioInitialize() {
        return LinkPredictionSplitConfig.super.negativeSamplingRatio();
    }

    private String testRelationshipTypeInitialize() {
        return LinkPredictionSplitConfig.super.testRelationshipType();
    }

    private String testComplementRelationshipTypeInitialize() {
        return LinkPredictionSplitConfig.super.testComplementRelationshipType();
    }

    private String trainRelationshipTypeInitialize() {
        return LinkPredictionSplitConfig.super.trainRelationshipType();
    }

    private String featureInputRelationshipTypeInitialize() {
        return LinkPredictionSplitConfig.super.featureInputRelationshipType();
    }

    private SplitRelationshipsBaseConfig testSplitInitialize() {
        return LinkPredictionSplitConfig.super.testSplit();
    }

    private SplitRelationshipsBaseConfig trainSplitInitialize() {
        return LinkPredictionSplitConfig.super.trainSplit();
    }

    @Override
    public int validationFolds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validationFolds() : this.validationFolds;
    }

    @Override
    public double testFraction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.testFraction() : this.testFraction;
    }

    @Override
    public double trainFraction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainFraction() : this.trainFraction;
    }

    @Override
    public double negativeSamplingRatio() {
        InitShim shim = this.initShim;
        return shim != null ? shim.negativeSamplingRatio() : this.negativeSamplingRatio;
    }

    @Override
    public String testRelationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.testRelationshipType() : this.testRelationshipType;
    }

    @Override
    public String testComplementRelationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.testComplementRelationshipType() : this.testComplementRelationshipType;
    }

    @Override
    public String trainRelationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainRelationshipType() : this.trainRelationshipType;
    }

    @Override
    public String featureInputRelationshipType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.featureInputRelationshipType() : this.featureInputRelationshipType;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.toMap;
    }

    @Override
    public SplitRelationshipsBaseConfig testSplit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.testSplit() : this.testSplit;
    }

    @Override
    public SplitRelationshipsBaseConfig trainSplit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trainSplit() : this.trainSplit;
    }

    public final ImmutableLinkPredictionSplitConfig withValidationFolds(int value) {
        if (this.validationFolds == value) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, value, this.testFraction, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withTestFraction(double value) {
        if (Double.doubleToLongBits(this.testFraction) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, value, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withTrainFraction(double value) {
        if (Double.doubleToLongBits(this.trainFraction) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, value, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withNegativeSamplingRatio(double value) {
        if (Double.doubleToLongBits(this.negativeSamplingRatio) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, value, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withTestRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "testRelationshipType");
        if (this.testRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, this.negativeSamplingRatio, newValue, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withTestComplementRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "testComplementRelationshipType");
        if (this.testComplementRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, newValue, this.trainRelationshipType, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withTrainRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "trainRelationshipType");
        if (this.trainRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, newValue, this.featureInputRelationshipType, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withFeatureInputRelationshipType(String value) {
        String newValue = Objects.requireNonNull(value, "featureInputRelationshipType");
        if (this.featureInputRelationshipType.equals(newValue)) {
            return this;
        }
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, newValue, this.toMap));
    }

    public final ImmutableLinkPredictionSplitConfig withToMap(Map<String, ? extends Object> entries) {
        if (this.toMap == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableLinkPredictionSplitConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this, this.validationFolds, this.testFraction, this.trainFraction, this.negativeSamplingRatio, this.testRelationshipType, this.testComplementRelationshipType, this.trainRelationshipType, this.featureInputRelationshipType, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLinkPredictionSplitConfig && this.equalTo((ImmutableLinkPredictionSplitConfig)another);
    }

    private boolean equalTo(ImmutableLinkPredictionSplitConfig another) {
        return this.validationFolds == another.validationFolds && Double.doubleToLongBits(this.testFraction) == Double.doubleToLongBits(another.testFraction) && Double.doubleToLongBits(this.trainFraction) == Double.doubleToLongBits(another.trainFraction) && Double.doubleToLongBits(this.negativeSamplingRatio) == Double.doubleToLongBits(another.negativeSamplingRatio) && this.testRelationshipType.equals(another.testRelationshipType) && this.testComplementRelationshipType.equals(another.testComplementRelationshipType) && this.trainRelationshipType.equals(another.trainRelationshipType) && this.featureInputRelationshipType.equals(another.featureInputRelationshipType) && this.toMap.equals(another.toMap) && this.testSplit.equals(another.testSplit) && this.trainSplit.equals(another.trainSplit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.validationFolds;
        h += (h << 5) + Double.hashCode(this.testFraction);
        h += (h << 5) + Double.hashCode(this.trainFraction);
        h += (h << 5) + Double.hashCode(this.negativeSamplingRatio);
        h += (h << 5) + this.testRelationshipType.hashCode();
        h += (h << 5) + this.testComplementRelationshipType.hashCode();
        h += (h << 5) + this.trainRelationshipType.hashCode();
        h += (h << 5) + this.featureInputRelationshipType.hashCode();
        h += (h << 5) + this.toMap.hashCode();
        h += (h << 5) + this.testSplit.hashCode();
        h += (h << 5) + this.trainSplit.hashCode();
        return h;
    }

    public String toString() {
        return "LinkPredictionSplitConfig{validationFolds=" + this.validationFolds + ", testFraction=" + this.testFraction + ", trainFraction=" + this.trainFraction + ", negativeSamplingRatio=" + this.negativeSamplingRatio + ", testRelationshipType=" + this.testRelationshipType + ", testComplementRelationshipType=" + this.testComplementRelationshipType + ", trainRelationshipType=" + this.trainRelationshipType + ", featureInputRelationshipType=" + this.featureInputRelationshipType + ", toMap=" + this.toMap + ", testSplit=" + this.testSplit + ", trainSplit=" + this.trainSplit + "}";
    }

    public static LinkPredictionSplitConfig of(int validationFolds, double testFraction, double trainFraction, double negativeSamplingRatio, String testRelationshipType, String testComplementRelationshipType, String trainRelationshipType, String featureInputRelationshipType, Map<String, ? extends Object> toMap) {
        return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(validationFolds, testFraction, trainFraction, negativeSamplingRatio, testRelationshipType, testComplementRelationshipType, trainRelationshipType, featureInputRelationshipType, toMap));
    }

    private static ImmutableLinkPredictionSplitConfig validate(ImmutableLinkPredictionSplitConfig instance) {
        instance.validFractionSum();
        return instance;
    }

    public static LinkPredictionSplitConfig copyOf(LinkPredictionSplitConfig instance) {
        if (instance instanceof ImmutableLinkPredictionSplitConfig) {
            return (ImmutableLinkPredictionSplitConfig)instance;
        }
        return ImmutableLinkPredictionSplitConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="LinkPredictionSplitConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_VALIDATION_FOLDS = 1L;
        private static final long OPT_BIT_TEST_FRACTION = 2L;
        private static final long OPT_BIT_TRAIN_FRACTION = 4L;
        private static final long OPT_BIT_NEGATIVE_SAMPLING_RATIO = 8L;
        private long optBits;
        private int validationFolds;
        private double testFraction;
        private double trainFraction;
        private double negativeSamplingRatio;
        private String testRelationshipType;
        private String testComplementRelationshipType;
        private String trainRelationshipType;
        private String featureInputRelationshipType;
        private Map<String, Object> toMap = null;

        private Builder() {
        }

        public final Builder from(LinkPredictionSplitConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToMapConvertible instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            LinkPredictionSplitConfig instance;
            long bits = 0L;
            if (object instanceof LinkPredictionSplitConfig) {
                instance = (LinkPredictionSplitConfig)object;
                this.negativeSamplingRatio(instance.negativeSamplingRatio());
                this.testComplementRelationshipType(instance.testComplementRelationshipType());
                this.testFraction(instance.testFraction());
                this.validationFolds(instance.validationFolds());
                this.trainRelationshipType(instance.trainRelationshipType());
                this.featureInputRelationshipType(instance.featureInputRelationshipType());
                if ((bits & 1L) == 0L) {
                    this.putAllToMap(instance.toMap());
                    bits |= 1L;
                }
                this.trainFraction(instance.trainFraction());
                this.testRelationshipType(instance.testRelationshipType());
            }
            if (object instanceof ToMapConvertible) {
                instance = (ToMapConvertible)object;
                if ((bits & 1L) == 0L) {
                    this.putAllToMap(instance.toMap());
                    bits |= 1L;
                }
            }
        }

        public final Builder validationFolds(int validationFolds) {
            this.validationFolds = validationFolds;
            this.optBits |= 1L;
            return this;
        }

        public final Builder testFraction(double testFraction) {
            this.testFraction = testFraction;
            this.optBits |= 2L;
            return this;
        }

        public final Builder trainFraction(double trainFraction) {
            this.trainFraction = trainFraction;
            this.optBits |= 4L;
            return this;
        }

        public final Builder negativeSamplingRatio(double negativeSamplingRatio) {
            this.negativeSamplingRatio = negativeSamplingRatio;
            this.optBits |= 8L;
            return this;
        }

        public final Builder testRelationshipType(String testRelationshipType) {
            this.testRelationshipType = Objects.requireNonNull(testRelationshipType, "testRelationshipType");
            return this;
        }

        public final Builder testComplementRelationshipType(String testComplementRelationshipType) {
            this.testComplementRelationshipType = Objects.requireNonNull(testComplementRelationshipType, "testComplementRelationshipType");
            return this;
        }

        public final Builder trainRelationshipType(String trainRelationshipType) {
            this.trainRelationshipType = Objects.requireNonNull(trainRelationshipType, "trainRelationshipType");
            return this;
        }

        public final Builder featureInputRelationshipType(String featureInputRelationshipType) {
            this.featureInputRelationshipType = Objects.requireNonNull(featureInputRelationshipType, "featureInputRelationshipType");
            return this;
        }

        public final Builder putToMap(String key, Object value) {
            if (this.toMap == null) {
                this.toMap = new LinkedHashMap<String, Object>();
            }
            this.toMap.put(Objects.requireNonNull(key, "toMap key"), Objects.requireNonNull(value, "toMap value"));
            return this;
        }

        public final Builder putToMap(Map.Entry<String, ? extends Object> entry) {
            if (this.toMap == null) {
                this.toMap = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.toMap.put(Objects.requireNonNull(k, "toMap key"), Objects.requireNonNull(v, "toMap value"));
            return this;
        }

        public final Builder toMap(Map<String, ? extends Object> entries) {
            this.toMap = new LinkedHashMap<String, Object>();
            return this.putAllToMap(entries);
        }

        public final Builder putAllToMap(Map<String, ? extends Object> entries) {
            if (this.toMap == null) {
                this.toMap = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.toMap.put(Objects.requireNonNull(k, "toMap key"), Objects.requireNonNull(v, "toMap value"));
            }
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.validationFolds = 0;
            this.testFraction = 0.0;
            this.trainFraction = 0.0;
            this.negativeSamplingRatio = 0.0;
            this.testRelationshipType = null;
            this.testComplementRelationshipType = null;
            this.trainRelationshipType = null;
            this.featureInputRelationshipType = null;
            if (this.toMap != null) {
                this.toMap.clear();
            }
            return this;
        }

        public LinkPredictionSplitConfig build() {
            return ImmutableLinkPredictionSplitConfig.validate(new ImmutableLinkPredictionSplitConfig(this));
        }

        private boolean validationFoldsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean testFractionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean trainFractionIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean negativeSamplingRatioIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="LinkPredictionSplitConfig", generator="Immutables")
    private final class InitShim {
        private byte validationFoldsBuildStage = 0;
        private int validationFolds;
        private byte testFractionBuildStage = 0;
        private double testFraction;
        private byte trainFractionBuildStage = 0;
        private double trainFraction;
        private byte negativeSamplingRatioBuildStage = 0;
        private double negativeSamplingRatio;
        private byte testRelationshipTypeBuildStage = 0;
        private String testRelationshipType;
        private byte testComplementRelationshipTypeBuildStage = 0;
        private String testComplementRelationshipType;
        private byte trainRelationshipTypeBuildStage = 0;
        private String trainRelationshipType;
        private byte featureInputRelationshipTypeBuildStage = 0;
        private String featureInputRelationshipType;
        private byte testSplitBuildStage = 0;
        private SplitRelationshipsBaseConfig testSplit;
        private byte trainSplitBuildStage = 0;
        private SplitRelationshipsBaseConfig trainSplit;

        private InitShim() {
        }

        int validationFolds() {
            if (this.validationFoldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validationFoldsBuildStage == 0) {
                this.validationFoldsBuildStage = (byte)-1;
                this.validationFolds = ImmutableLinkPredictionSplitConfig.this.validationFoldsInitialize();
                this.validationFoldsBuildStage = 1;
            }
            return this.validationFolds;
        }

        void validationFolds(int validationFolds) {
            this.validationFolds = validationFolds;
            this.validationFoldsBuildStage = 1;
        }

        double testFraction() {
            if (this.testFractionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testFractionBuildStage == 0) {
                this.testFractionBuildStage = (byte)-1;
                this.testFraction = ImmutableLinkPredictionSplitConfig.this.testFractionInitialize();
                this.testFractionBuildStage = 1;
            }
            return this.testFraction;
        }

        void testFraction(double testFraction) {
            this.testFraction = testFraction;
            this.testFractionBuildStage = 1;
        }

        double trainFraction() {
            if (this.trainFractionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainFractionBuildStage == 0) {
                this.trainFractionBuildStage = (byte)-1;
                this.trainFraction = ImmutableLinkPredictionSplitConfig.this.trainFractionInitialize();
                this.trainFractionBuildStage = 1;
            }
            return this.trainFraction;
        }

        void trainFraction(double trainFraction) {
            this.trainFraction = trainFraction;
            this.trainFractionBuildStage = 1;
        }

        double negativeSamplingRatio() {
            if (this.negativeSamplingRatioBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.negativeSamplingRatioBuildStage == 0) {
                this.negativeSamplingRatioBuildStage = (byte)-1;
                this.negativeSamplingRatio = ImmutableLinkPredictionSplitConfig.this.negativeSamplingRatioInitialize();
                this.negativeSamplingRatioBuildStage = 1;
            }
            return this.negativeSamplingRatio;
        }

        void negativeSamplingRatio(double negativeSamplingRatio) {
            this.negativeSamplingRatio = negativeSamplingRatio;
            this.negativeSamplingRatioBuildStage = 1;
        }

        String testRelationshipType() {
            if (this.testRelationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testRelationshipTypeBuildStage == 0) {
                this.testRelationshipTypeBuildStage = (byte)-1;
                this.testRelationshipType = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.testRelationshipTypeInitialize(), "testRelationshipType");
                this.testRelationshipTypeBuildStage = 1;
            }
            return this.testRelationshipType;
        }

        void testRelationshipType(String testRelationshipType) {
            this.testRelationshipType = testRelationshipType;
            this.testRelationshipTypeBuildStage = 1;
        }

        String testComplementRelationshipType() {
            if (this.testComplementRelationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testComplementRelationshipTypeBuildStage == 0) {
                this.testComplementRelationshipTypeBuildStage = (byte)-1;
                this.testComplementRelationshipType = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.testComplementRelationshipTypeInitialize(), "testComplementRelationshipType");
                this.testComplementRelationshipTypeBuildStage = 1;
            }
            return this.testComplementRelationshipType;
        }

        void testComplementRelationshipType(String testComplementRelationshipType) {
            this.testComplementRelationshipType = testComplementRelationshipType;
            this.testComplementRelationshipTypeBuildStage = 1;
        }

        String trainRelationshipType() {
            if (this.trainRelationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainRelationshipTypeBuildStage == 0) {
                this.trainRelationshipTypeBuildStage = (byte)-1;
                this.trainRelationshipType = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.trainRelationshipTypeInitialize(), "trainRelationshipType");
                this.trainRelationshipTypeBuildStage = 1;
            }
            return this.trainRelationshipType;
        }

        void trainRelationshipType(String trainRelationshipType) {
            this.trainRelationshipType = trainRelationshipType;
            this.trainRelationshipTypeBuildStage = 1;
        }

        String featureInputRelationshipType() {
            if (this.featureInputRelationshipTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.featureInputRelationshipTypeBuildStage == 0) {
                this.featureInputRelationshipTypeBuildStage = (byte)-1;
                this.featureInputRelationshipType = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.featureInputRelationshipTypeInitialize(), "featureInputRelationshipType");
                this.featureInputRelationshipTypeBuildStage = 1;
            }
            return this.featureInputRelationshipType;
        }

        void featureInputRelationshipType(String featureInputRelationshipType) {
            this.featureInputRelationshipType = featureInputRelationshipType;
            this.featureInputRelationshipTypeBuildStage = 1;
        }

        SplitRelationshipsBaseConfig testSplit() {
            if (this.testSplitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.testSplitBuildStage == 0) {
                this.testSplitBuildStage = (byte)-1;
                this.testSplit = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.testSplitInitialize(), "testSplit");
                this.testSplitBuildStage = 1;
            }
            return this.testSplit;
        }

        SplitRelationshipsBaseConfig trainSplit() {
            if (this.trainSplitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trainSplitBuildStage == 0) {
                this.trainSplitBuildStage = (byte)-1;
                this.trainSplit = Objects.requireNonNull(ImmutableLinkPredictionSplitConfig.this.trainSplitInitialize(), "trainSplit");
                this.trainSplitBuildStage = 1;
            }
            return this.trainSplit;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.validationFoldsBuildStage == -1) {
                attributes.add("validationFolds");
            }
            if (this.testFractionBuildStage == -1) {
                attributes.add("testFraction");
            }
            if (this.trainFractionBuildStage == -1) {
                attributes.add("trainFraction");
            }
            if (this.negativeSamplingRatioBuildStage == -1) {
                attributes.add("negativeSamplingRatio");
            }
            if (this.testRelationshipTypeBuildStage == -1) {
                attributes.add("testRelationshipType");
            }
            if (this.testComplementRelationshipTypeBuildStage == -1) {
                attributes.add("testComplementRelationshipType");
            }
            if (this.trainRelationshipTypeBuildStage == -1) {
                attributes.add("trainRelationshipType");
            }
            if (this.featureInputRelationshipTypeBuildStage == -1) {
                attributes.add("featureInputRelationshipType");
            }
            if (this.testSplitBuildStage == -1) {
                attributes.add("testSplit");
            }
            if (this.trainSplitBuildStage == -1) {
                attributes.add("trainSplit");
            }
            return "Cannot build LinkPredictionSplitConfig, attribute initializers form cycle " + attributes;
        }
    }
}

