/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.MutateProc;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.IdMapping;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.config.GraphCreateConfigValidations;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.ml.linkmodels.ExhaustiveLinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredict;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictFactory;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictMutateConfig;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardMutateResult;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

public class LinkPredictionPredictMutateProc
extends MutateProc<LinkPredictionPredict, ExhaustiveLinkPredictionResult, MutateResult, LinkPredictionPredictMutateConfig> {
    @Context
    public ModelCatalog modelCatalog;

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model.")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.ml.linkPrediction.predict.mutate.estimate", mode=Mode.READ)
    @Description(value="Estimates memory for applying a linkPrediction model")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected void validateConfigsBeforeLoad(GraphCreateConfig graphCreateConfig, LinkPredictionPredictMutateConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected LinkPredictionPredictMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPredictMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictMutateConfig> algorithmFactory() {
        return new LinkPredictionPredictFactory(this.modelCatalog);
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<LinkPredictionPredict, ExhaustiveLinkPredictionResult, LinkPredictionPredictMutateConfig> computationResult) {
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((IdMapping)computationResult.graph()).orientation(Orientation.UNDIRECTED).addPropertyConfig(Aggregation.NONE, DefaultValue.forDouble()).concurrency(1).executorService(Pools.DEFAULT).allocationTracker(this.allocationTracker()).build();
        ((ExhaustiveLinkPredictionResult)computationResult.result()).stream().forEach(predictedLink -> relationshipsBuilder.addFromInternal(predictedLink.sourceId(), predictedLink.targetId(), predictedLink.probability()));
        Relationships relationships = relationshipsBuilder.build();
        LinkPredictionPredictMutateConfig config = (LinkPredictionPredictMutateConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
        }
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

