/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.utils.StringFormatting;

public final class InputNodeValidator {
    public static void validateStartNode(long nodeId, Graph graph) throws IllegalArgumentException {
        InputNodeValidator.validateNodeIsLoaded(nodeId, graph.toMappedNodeId(nodeId), "startNode");
    }

    public static void validateEndNode(long nodeId, Graph graph) throws IllegalArgumentException {
        InputNodeValidator.validateNodeIsLoaded(nodeId, graph.toMappedNodeId(nodeId), "endNode");
    }

    private static void validateNodeIsLoaded(long nodeId, long mappedId, String nodeDescription) throws IllegalArgumentException {
        if (mappedId == -1L) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s with id %d was not loaded", (Object[])new Object[]{nodeDescription, nodeId}));
        }
    }
}

