/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.config.GraphCreateConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.mem.AllocationTracker;
import org.neo4j.gds.impl.similarity.PearsonAlgorithm;
import org.neo4j.gds.impl.similarity.PearsonConfig;
import org.neo4j.gds.impl.similarity.PearsonConfigImpl;
import org.neo4j.gds.impl.similarity.SimilarityConfig;
import org.neo4j.gds.results.SimilarityResult;
import org.neo4j.gds.similarity.AlphaSimilarityProc;
import org.neo4j.gds.similarity.AlphaSimilarityStatsResult;
import org.neo4j.gds.similarity.AlphaSimilaritySummaryResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class PearsonProc
extends AlphaSimilarityProc<PearsonAlgorithm, PearsonConfig> {
    private static final String DESCRIPTION = "Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.";

    @Procedure(name="gds.alpha.similarity.pearson.stream", mode=Mode.READ)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<SimilarityResult> pearsonStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.pearson.write", mode=Mode.WRITE)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<AlphaSimilaritySummaryResult> pearsonWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.pearson.stats", mode=Mode.READ)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<AlphaSimilarityStatsResult> pearsonStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected PearsonConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new PearsonConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    PearsonAlgorithm newAlgo(PearsonConfig config, AllocationTracker allocationTracker) {
        return new PearsonAlgorithm((SimilarityConfig)config, this.api);
    }

    @Override
    String taskName() {
        return "Pearson-similarity";
    }
}

